/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.neoforge;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.potionstudios.biomeswevegone.config.configs.BWGTradesConfig;
import net.potionstudios.biomeswevegone.util.BoneMealHandler;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerTrades;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import net.potionstudios.biomeswevegone.world.item.brewing.BWGBrewingRecipes;
import net.potionstudios.biomeswevegone.world.item.tools.ToolInteractions;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.BlockFeatures;
import org.apache.logging.log4j.util.TriConsumer;

public class VanillaCompatNeoForge {
    public static void init() {
        ToolInteractions.registerStrippableBlocks((block, stripped) -> {
            AxeItem.STRIPPABLES = new HashMap(AxeItem.STRIPPABLES);
            AxeItem.STRIPPABLES.put(block, stripped);
        });
        BlockFeatures.registerFlammable((TriConsumer<Block, Integer, Integer>)((TriConsumer)(arg_0, arg_1, arg_2) -> ((FireBlock)((FireBlock)Blocks.FIRE)).setFlammable(arg_0, arg_1, arg_2)));
        ToolInteractions.registerFlattenables(ShovelItem.FLATTENABLES::put);
    }

    public static void registerVanillaCompatEvents(IEventBus bus) {
        bus.addListener(VanillaCompatNeoForge::registerTillables);
        if (!BWGTradesConfig.INSTANCE.trades.disableTrades.value().booleanValue()) {
            bus.addListener(VanillaCompatNeoForge::onVillagerTrade);
            if (BWGTradesConfig.INSTANCE.wanderingTraderTrades.enableBWGItemsTrades.value().booleanValue()) {
                bus.addListener(VanillaCompatNeoForge::onWanderingTrade);
            }
        }
        bus.addListener(VanillaCompatNeoForge::onBoneMealUse);
        bus.addListener(VanillaCompatNeoForge::registerBrewingRecipes);
        bus.addListener(VanillaCompatNeoForge::onEnderManAnger);
        bus.addListener(VanillaCompatNeoForge::onVillagerInteract);
    }

    private static void registerTillables(BlockEvent.BlockToolModificationEvent event) {
        if (event.getItemAbility() == ItemAbilities.HOE_TILL && event.getLevel().getBlockState(event.getPos().above()).isAir()) {
            BlockState state = event.getState();
            if (state.is((Block)BWGBlocks.LUSH_GRASS_BLOCK.get()) || state.is(BWGBlocks.LUSH_DIRT.get())) {
                event.setFinalState(BWGBlocks.LUSH_FARMLAND.get().defaultBlockState());
            } else if (state.is(BWGBlocks.SANDY_DIRT.get())) {
                event.setFinalState(BWGBlocks.SANDY_FARMLAND.get().defaultBlockState());
            } else if (state.is(BWGBlocks.PEAT.get())) {
                event.setFinalState(Blocks.FARMLAND.defaultBlockState());
            }
        }
    }

    private static void onVillagerTrade(VillagerTradesEvent event) {
        if (BWGVillagerTrades.TRADES.containsKey(event.getType())) {
            Int2ObjectMap trades = event.getTrades();
            BWGVillagerTrades.TRADES.get(event.getType()).forEach((level, offers) -> {
                List tradeList = (List)trades.get(level.intValue());
                for (MerchantOffer offer : offers) {
                    tradeList.add((trader, random) -> offer);
                }
            });
        }
    }

    private static void onWanderingTrade(WandererTradesEvent event) {
        BWGVillagerTrades.WANDERING_TRADER_TRADES.forEach((level, offers) -> {
            for (MerchantOffer offer : offers) {
                event.getGenericTrades().add((trader, random) -> offer);
            }
        });
    }

    private static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        BWGBrewingRecipes.buildBrewingRecipes((TriConsumer<Holder<Potion>, Item, Holder<Potion>>)((TriConsumer)(arg_0, arg_1, arg_2) -> ((PotionBrewing.Builder)event.getBuilder()).addMix(arg_0, arg_1, arg_2)));
    }

    private static void onEnderManAnger(EnderManAngerEvent event) {
        if (event.getPlayer().getItemBySlot(EquipmentSlot.HEAD).is(BWGBlocks.CARVED_PALE_PUMPKIN.get().asItem())) {
            event.setCanceled(true);
        }
    }

    private static void onBoneMealUse(BonemealEvent event) {
        if (!event.getLevel().isClientSide() && BoneMealHandler.bwgBoneMealEventHandler((ServerLevel)event.getLevel(), event.getPos(), event.getState())) {
            event.setSuccessful(true);
        }
    }

    private static void onVillagerInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        event.setCancellationResult(PumpkinWarden.villagerToPumpkinWarden(event.getTarget(), event.getItemStack(), event.getLevel()) ? InteractionResult.SUCCESS : InteractionResult.PASS);
    }
}

