/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.culturaldelights.world;

import com.baisylia.culturaldelights.block.ModBlocks;
import com.baisylia.culturaldelights.world.ModConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> AVOCADO_PLACED_KEY = ModPlacedFeatures.registerKey("avocado_placed");
    public static final ResourceKey<PlacedFeature> CORN_PLACED_KEY = ModPlacedFeatures.registerKey("corn_placed");
    public static final ResourceKey<PlacedFeature> EGGPLANT_PLACED_KEY = ModPlacedFeatures.registerKey("eggplant_placed");
    public static final ResourceKey<PlacedFeature> CUCUMBER_PLACED_KEY = ModPlacedFeatures.registerKey("cucumber_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, AVOCADO_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.AVOCADO_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.1f, (int)1), (Block)((Block)ModBlocks.AVOCADO_SAPLING.get())));
        ModPlacedFeatures.register(context, CORN_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.CORN_KEY), List.of(RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, EGGPLANT_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.EGGPLANT_KEY), List.of(RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, CUCUMBER_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.CUCUMBER_KEY), List.of(RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"culturaldelights", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

