/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.jem_objects;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFException;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModelMappings;
import traben.entity_model_features.models.EMFModel_ID;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFDirectoryHandler;
import traben.entity_model_features.utils.EMFUtils;

public class EMFJemData {
    private final LinkedHashMap<String, List<LinkedHashMap<String, String>>> allTopLevelAnimationsByVanillaPartName = new LinkedHashMap();
    public String texture = "";
    public int[] textureSize = null;
    public double shadow_size = 1.0;
    public LinkedList<EMFPartData> models = new LinkedList();
    public EMFDirectoryHandler directoryContext = null;
    private EMFModel_ID mobModelIDInfo = null;
    private ResourceLocation customTexture = null;

    public LinkedHashMap<String, List<LinkedHashMap<String, String>>> getAllTopLevelAnimationsByVanillaPartName() {
        return this.allTopLevelAnimationsByVanillaPartName;
    }

    public EMFModel_ID getMobModelIDInfo() {
        return this.mobModelIDInfo;
    }

    public ResourceLocation getCustomTexture() {
        return this.customTexture;
    }

    @Nullable
    public ResourceLocation validateJemTexture(String textureIn) {
        return this.validateJemTexture(textureIn, false);
    }

    @Nullable
    public ResourceLocation validateJemTexture(String textureIn, boolean canRemoveRedundancy) {
        if (textureIn == null || textureIn.isBlank()) {
            return null;
        }
        Object textureTest = textureIn.trim();
        if (!((String)textureTest).isBlank()) {
            if (!((String)textureTest).endsWith(".png")) {
                textureTest = (String)textureTest + ".png";
            }
            if (!((String)textureTest).contains(":")) {
                if (!((String)textureTest).contains("/")) {
                    textureTest = this.directoryContext.getRelativeDirectoryLocationNoValidation((String)textureTest);
                } else if (((String)textureTest).startsWith("./")) {
                    textureTest = this.directoryContext.getRelativeDirectoryLocationNoValidation(((String)textureTest).replaceFirst("\\./", ""));
                } else if (((String)textureTest).startsWith("~/")) {
                    textureTest = "optifine/" + ((String)textureTest).replaceFirst("~/", "");
                }
            }
            if (canRemoveRedundancy && "minecraft".equals(this.directoryContext.namespace) && (!((String)textureTest).contains(":") || ((String)textureTest).startsWith("minecraft:"))) {
                Object object = textureTest = ((String)textureTest).startsWith("minecraft:") ? textureTest : "minecraft:" + (String)textureTest;
                if (((String)textureTest).equals(EMFModelMappings.DEFAULT_TEXTURE_MAPPINGS.get(this.directoryContext.rawFileName))) {
                    if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                        EMFUtils.log("Removing redundant texture: " + (String)textureTest + " declared in " + this.directoryContext.getFileNameWithType());
                    }
                    return null;
                }
            }
            if (ResourceLocation.tryParse((String)textureTest) != null) {
                ResourceLocation possibleTexture = EMFUtils.res((String)textureTest);
                if (Minecraft.getInstance().getResourceManager().getResource(possibleTexture).isPresent()) {
                    return possibleTexture;
                }
            } else {
                EMFUtils.logWarn("Invalid texture identifier: " + (String)textureTest + " for " + this.directoryContext.getFileNameWithType());
            }
        }
        return MissingTextureAtlasSprite.getLocation();
    }

    public void prepare(EMFDirectoryHandler directoryContext, EMFModel_ID mobModelIDInfo) {
        try {
            this.directoryContext = directoryContext;
            this.mobModelIDInfo = mobModelIDInfo;
            if (this.textureSize != null && this.textureSize.length != 2) {
                this.textureSize = new int[]{64, 32};
                EMFUtils.logWarn("No textureSize provided for: " + directoryContext.getFileNameWithType() + ". Defaulting to 64x32 texture size for model.");
            }
            LinkedList<EMFPartData> originalModelsForReadingOnly = new LinkedList<EMFPartData>(this.models);
            this.customTexture = this.validateJemTexture(this.texture, true);
            Map<String, String> map = EMFModelMappings.getMapOf(mobModelIDInfo, null);
            for (EMFPartData eMFPartData : this.models) {
                if (eMFPartData.part == null || !map.containsKey(eMFPartData.part)) continue;
                eMFPartData.originalPart = eMFPartData.part;
                eMFPartData.part = map.get(eMFPartData.part);
            }
            for (EMFPartData eMFPartData : this.models) {
                eMFPartData.prepare(this.textureSize, this);
            }
            TreeMap alphabeticalOrderedParts = new TreeMap(Comparator.naturalOrder());
            if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                EMFUtils.log("originalModelsForReadingOnly #= " + originalModelsForReadingOnly.size());
            }
            for (EMFPartData partData : originalModelsForReadingOnly) {
                String newId = EMFUtils.getIdUnique(alphabeticalOrderedParts.keySet(), partData.id);
                if (!newId.equals(partData.id)) {
                    partData.id = newId;
                }
                alphabeticalOrderedParts.put(partData.id, partData);
            }
            if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                EMFUtils.log("alphabeticalOrderedParts = " + String.valueOf(alphabeticalOrderedParts));
            }
            for (EMFPartData part : alphabeticalOrderedParts.values()) {
                if (part.animations == null) continue;
                LinkedList list = new LinkedList();
                for (LinkedHashMap linkedHashMap : part.animations) {
                    LinkedHashMap thisPartsAnimations = new LinkedHashMap();
                    linkedHashMap.forEach((key, anim) -> {
                        key = key.trim().replaceAll("\\s", "");
                        anim = anim.trim().replaceAll("\\s", "");
                        if (key.contains("this")) {
                            key = key.replaceFirst("(?<=\\W|^)this(?=\\W)", part.id);
                        }
                        if (anim.contains("this")) {
                            anim = anim.replaceAll("(?<=\\W|^)this(?=\\W)", part.id);
                        }
                        if (key.contains("part")) {
                            key = key.replaceFirst("(?<=\\W|^)part(?=\\W)", Objects.requireNonNullElse(part.originalPart, part.part));
                        }
                        if (anim.contains("part")) {
                            anim = anim.replaceAll("(?<=\\W|^)part(?=\\W)", Objects.requireNonNullElse(part.originalPart, part.part));
                        }
                        if (!key.isBlank() && !anim.isBlank()) {
                            thisPartsAnimations.put(key, anim);
                        }
                    });
                    if (thisPartsAnimations.isEmpty()) continue;
                    list.add(thisPartsAnimations);
                }
                if (list.isEmpty()) continue;
                this.allTopLevelAnimationsByVanillaPartName.computeIfAbsent(part.part, k -> new LinkedList()).addAll(list);
            }
            if (this.shadow_size != 1.0) {
                this.shadow_size = Math.max(this.shadow_size, 0.0);
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                linkedHashMap.put("render.shadow_size", String.valueOf(this.shadow_size));
                this.allTopLevelAnimationsByVanillaPartName.computeIfAbsent("root", k -> new LinkedList()).add(linkedHashMap);
            }
        }
        catch (Exception e) {
            String message = "Error preparing jem data, for model [" + mobModelIDInfo.getDisplayFileName() + "]: " + e.getMessage();
            EMFUtils.logError(message);
            throw EMFException.recordException(new RuntimeException(message));
        }
    }

    public String toString() {
        return "EMF_JemData{texture='" + this.texture + "', textureSize=" + Arrays.toString(this.textureSize) + ", shadow_size=" + this.shadow_size + ", models=" + this.models.toString() + "}";
    }
}

