/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanical_cow.content;

import com.oierbravo.mechanical_cow.MechanicalCow;
import com.oierbravo.mechanical_cow.infrastructure.config.MConfigs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;

public class MechanicalCowConfigUtils {
    public static Ingredient getRequiredIngredient() {
        Ingredient requiredItemIngredient = Ingredient.EMPTY;
        String itemResourceRaw = (String)MConfigs.server().mechanicalCow.requiredIngredient.get();
        if (itemResourceRaw.startsWith("#")) {
            ResourceLocation itemTag = ResourceLocation.tryParse((String)itemResourceRaw.replace("#", ""));
            assert (itemTag != null);
            return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)itemTag));
        }
        ResourceLocation desiredItem = ResourceLocation.parse((String)itemResourceRaw);
        if (BuiltInRegistries.ITEM.containsKey(desiredItem)) {
            requiredItemIngredient = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(desiredItem)});
        } else {
            MechanicalCow.LOGGER.error("Unknown item '{}' in config, using default '{}' instead", (Object)itemResourceRaw, (Object)"minecraft:wheat");
            requiredItemIngredient = Ingredient.of((TagKey)Tags.Items.CROPS_WHEAT);
        }
        return requiredItemIngredient;
    }

    public static FluidStack getOutputFluidStack() {
        FluidStack outputFluid = FluidStack.EMPTY;
        int outputAmount = (Integer)MConfigs.server().mechanicalCow.outputAmount.get();
        String fluidResource = (String)MConfigs.server().mechanicalCow.outputFluid.get();
        ResourceLocation desiredFluid = ResourceLocation.parse((String)fluidResource);
        if (BuiltInRegistries.FLUID.containsKey(desiredFluid)) {
            outputFluid = new FluidStack((Fluid)BuiltInRegistries.FLUID.get(desiredFluid), outputAmount);
        } else {
            MechanicalCow.LOGGER.error("Unknown fluid '{}' in config, using default '{}' instead", (Object)fluidResource, (Object)"minecraft:milk");
            outputFluid = new FluidStack((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)"minecraft:milk")), outputAmount);
        }
        return outputFluid;
    }
}

