/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanical_cow;

import com.mojang.logging.LogUtils;
import com.oierbravo.mechanical_cow.content.MechanicalCowBlockEntity;
import com.oierbravo.mechanical_cow.infrastructure.config.MConfigs;
import com.oierbravo.mechanical_cow.infrastructure.data.ModDataGen;
import com.oierbravo.mechanical_cow.ponders.ModPonderPlugin;
import com.oierbravo.mechanical_cow.registrate.ModBlockEntities;
import com.oierbravo.mechanical_cow.registrate.ModBlocks;
import com.oierbravo.mechanical_cow.registrate.ModCreativeTabs;
import com.oierbravo.mechanical_cow.registrate.ModPartials;
import com.oierbravo.mechanicals.utility.RegistrateLangBuilder;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.AbstractRegistrate;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.slf4j.Logger;

@Mod(value="mechanical_cow")
public class MechanicalCow {
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"mechanical_cow").defaultCreativeTab(ModCreativeTabs.MAIN_TAB.getKey());
    public static final Logger LOGGER;

    public MechanicalCow(IEventBus modEventBus, ModContainer modContainer) {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        REGISTRATE.registerEventListeners(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModBlocks.register();
        ModBlockEntities.register();
        MConfigs.register(modLoadingContext, modContainer);
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(ModDataGen::gatherData);
        this.generateLangEntries();
    }

    private void generateLangEntries() {
        new RegistrateLangBuilder("mechanical_cow", (AbstractRegistrate)MechanicalCow.registrate()).addJade("Create Mechanical Cow").addCreativeTab("Create Mechanical Cow").addBlockTooltipSummary("mechanical_cow", "Cow _Milk_ generator.").add("mechanical_cow.tooltip.progress", "Progress: %d%%").addPonderHeader("mechanical_cow", "Mechanical Milk generator").addPonderText(1, "mechanical_cow", "The Mechanical Cow uses rotational force and an specific ingredient to generate milk").addPonderText(2, "mechanical_cow", "Its powered from the bottom").addPonderText(3, "mechanical_cow", "Item input can ONLY go from the FRONT side").addPonderText(4, "mechanical_cow", "Can only be inserted by automation").addPonderText(5, "mechanical_cow", "Milk output is ONLY located on the BACK side").addPonderText(6, "mechanical_cow", "Can only be extracted by automation").add("recipe", "Mechanical Cow Recipe");
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        MechanicalCowBlockEntity.registerCapabilities(event);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ModPartials.init();
        PonderIndex.addPlugin((PonderPlugin)new ModPonderPlugin());
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        LOGGER = LogUtils.getLogger();
    }
}

