/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.integration.PermissionsHelper;
import dev.ftb.mods.ftbquests.net.ClearDisplayCacheMessage;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.OpenQuestBookMessage;
import dev.ftb.mods.ftbquests.net.SyncEditorPermissionMessage;
import dev.ftb.mods.ftbquests.net.SyncQuestsMessage;
import dev.ftb.mods.ftbquests.net.SyncTranslationMessageToClient;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.translation.TranslationKey;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsCommands {
    public static final SimpleCommandExceptionType NO_FILE = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.ftbquests.command.error.no_file"));
    public static final DynamicCommandExceptionType NO_OBJECT = new DynamicCommandExceptionType(object -> Component.translatable((String)"commands.ftbquests.command.error.no_object", (Object[])new Object[]{object}));
    public static final DynamicCommandExceptionType INVALID_ID = new DynamicCommandExceptionType(id -> Component.translatable((String)"commands.ftbquests.command.error.invalid_id", (Object[])new Object[]{id}));
    private static final SimpleCommandExceptionType NO_INVENTORY = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.ftbquests.command.error.no_inventory"));
    private static final Set<UUID> warnedPlayers = new HashSet<UUID>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ftbquests").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"editing_mode").requires(FTBQuestsCommands::isSSPOrEditor)).executes(c -> FTBQuestsCommands.editingMode((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.editingMode((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(c -> FTBQuestsCommands.editingMode((CommandSourceStack)c.getSource(), EntityArgument.getPlayer((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"locked").requires(FTBQuestsCommands::hasEditorPermission)).executes(c -> FTBQuestsCommands.locked((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.locked((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(c -> FTBQuestsCommands.locked((CommandSourceStack)c.getSource(), EntityArgument.getPlayer((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"delete_empty_reward_tables").requires(FTBQuestsCommands::hasEditorPermission)).executes(context -> FTBQuestsCommands.deleteEmptyRewardTables((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"change_progress").requires(FTBQuestsCommands::hasEditorPermission)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"reset").then(Commands.argument((String)"quest_object", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"players");
            return FTBQuestsCommands.changeProgress((CommandSourceStack)ctx.getSource(), players, true, StringArgumentType.getString((CommandContext)ctx, (String)"quest_object"));
        })))).then(Commands.literal((String)"reset-all").executes(ctx -> {
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"players");
            return FTBQuestsCommands.changeProgress((CommandSourceStack)ctx.getSource(), players, true, "1");
        }))).then(Commands.literal((String)"complete").then(Commands.argument((String)"quest_object", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"players");
            return FTBQuestsCommands.changeProgress((CommandSourceStack)ctx.getSource(), players, false, StringArgumentType.getString((CommandContext)ctx, (String)"quest_object"));
        })))).then(Commands.literal((String)"complete-all").executes(ctx -> {
            Collection players = EntityArgument.getPlayers((CommandContext)ctx, (String)"players");
            return FTBQuestsCommands.changeProgress((CommandSourceStack)ctx.getSource(), players, false, "1");
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"export_reward_table_to_chest").requires(FTBQuestsCommands::hasEditorPermission)).then(((RequiredArgumentBuilder)Commands.argument((String)"reward_table", (ArgumentType)StringArgumentType.string()).executes(ctx -> FTBQuestsCommands.exportRewards((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"reward_table"), null))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> {
            BlockPos pos = BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)"pos");
            return FTBQuestsCommands.exportRewards((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"reward_table"), pos);
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"import_reward_table_from_chest").requires(FTBQuestsCommands::hasEditorPermission)).then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return FTBQuestsCommands.importRewards((CommandSourceStack)ctx.getSource(), name, null);
        })).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            BlockPos pos = BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)"pos");
            return FTBQuestsCommands.importRewards((CommandSourceStack)ctx.getSource(), name, pos);
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"generate_chapter_with_all_items_in_game").requires(FTBQuestsCommands::hasEditorPermission)).executes(context -> FTBQuestsCommands.generateAllItemChapter((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(FTBQuestsCommands::hasEditorPermission)).executes(context -> FTBQuestsCommands.doReload((CommandSourceStack)context.getSource(), true, true))).then(Commands.literal((String)"quests").executes(context -> FTBQuestsCommands.doReload((CommandSourceStack)context.getSource(), true, false)))).then(Commands.literal((String)"team_progress").executes(context -> FTBQuestsCommands.doReload((CommandSourceStack)context.getSource(), false, true))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"block_rewards").requires(FTBQuestsCommands::hasEditorPermission)).executes(c -> FTBQuestsCommands.toggleRewardBlocking((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.toggleRewardBlocking((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getPlayerOrException(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(FTBQuestsCommands::hasEditorPermission)).executes(c -> FTBQuestsCommands.toggleRewardBlocking((CommandSourceStack)c.getSource(), EntityArgument.getPlayer((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"open_book").executes(c -> FTBQuestsCommands.openQuest(((CommandSourceStack)c.getSource()).getPlayerOrException(), null))).then(Commands.argument((String)"quest_object", (ArgumentType)StringArgumentType.string()).executes(c -> FTBQuestsCommands.openQuest(((CommandSourceStack)c.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)c, (String)"quest_object")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear_item_display_cache").requires(FTBQuestsCommands::hasEditorPermission)).executes(c -> FTBQuestsCommands.clearDisplayCache((CommandSourceStack)c.getSource()))));
    }

    private static boolean isSSPOrEditor(CommandSourceStack s) {
        return s.getServer() != null && s.getServer().isSingleplayer() || FTBQuestsCommands.hasEditorPermission(s);
    }

    private static boolean hasEditorPermission(CommandSourceStack stack) {
        return stack.hasPermission(2) || stack.isPlayer() && PermissionsHelper.hasEditorPermission(stack.getPlayer(), false);
    }

    private static QuestObjectBase getQuestObjectForString(String idStr) throws CommandSyntaxException {
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null) {
            throw NO_FILE.create();
        }
        if (idStr.startsWith("#")) {
            String val = idStr.substring(1);
            for (QuestObjectBase qob : file.getAllObjects()) {
                if (!qob.hasTag(val)) continue;
                return qob;
            }
            throw NO_OBJECT.create((Object)idStr);
        }
        long id = QuestObjectBase.parseHexId(idStr).orElseThrow(() -> INVALID_ID.create((Object)idStr));
        QuestObjectBase qob = file.getBase(id);
        if (qob == null) {
            throw NO_OBJECT.create((Object)idStr);
        }
        return qob;
    }

    private static boolean playerCanSeeQuestObject(ServerPlayer player, QuestObject qo) {
        if (qo instanceof Chapter) {
            return true;
        }
        return ServerQuestFile.INSTANCE.getTeamData((Player)player).map(data -> {
            Quest quest = qo.getRelatedQuest();
            return quest != null && (data.getCanEdit((Player)player) || !quest.hideDetailsUntilStartable() || data.canStartTasks(quest));
        }).orElse(false);
    }

    private static int openQuest(ServerPlayer player, String qobId) throws CommandSyntaxException {
        Quest quest;
        if (qobId == null) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)OpenQuestBookMessage.lastOpenedQuest());
            return 1;
        }
        QuestObjectBase questObjectBase = FTBQuestsCommands.getQuestObjectForString(qobId);
        if (questObjectBase instanceof Quest && FTBQuestsCommands.playerCanSeeQuestObject(player, quest = (Quest)questObjectBase)) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OpenQuestBookMessage(quest.id));
            return 1;
        }
        return 0;
    }

    private static int exportRewards(CommandSourceStack source, String idStr, @Nullable BlockPos pos) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ServerLevel level = source.getLevel();
        QuestObjectBase questObjectBase = FTBQuestsCommands.getQuestObjectForString(idStr);
        if (!(questObjectBase instanceof RewardTable)) {
            throw NO_OBJECT.create((Object)idStr);
        }
        RewardTable table = (RewardTable)questObjectBase;
        pos = Objects.requireNonNullElse(pos, BlockPos.containing((Position)player.pick(10.0, 1.0f, false).getLocation()));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof BaseContainerBlockEntity)) {
            throw NO_INVENTORY.create();
        }
        BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
        container.clearContent();
        int slot = 0;
        for (WeightedReward wr : table.getWeightedRewards()) {
            if (slot >= container.getContainerSize()) {
                source.sendFailure((Component)Component.translatable((String)"commands.ftbquests.command.feedback.table_too_many_items", (Object[])new Object[]{table.getTitle()}));
                return 0;
            }
            Reward reward = wr.getReward();
            if (!(reward instanceof ItemReward)) continue;
            ItemReward itemReward = (ItemReward)reward;
            container.setItem(slot++, itemReward.getItem());
        }
        source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.command.feedback.table_exported", (Object[])new Object[]{table.getTitle(), table.getWeightedRewards().size()}), false);
        return 1;
    }

    private static int importRewards(CommandSourceStack source, String name, BlockPos pos) throws CommandSyntaxException {
        BlockEntity be;
        ServerPlayer player = source.getPlayerOrException();
        ServerLevel level = source.getLevel();
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (pos == null) {
            pos = BlockPos.containing((Position)player.pick(10.0, 1.0f, false).getLocation());
        }
        if (!((be = level.getBlockEntity(pos)) instanceof BaseContainerBlockEntity)) {
            throw NO_INVENTORY.create();
        }
        BaseContainerBlockEntity container = (BaseContainerBlockEntity)be;
        RewardTable table = new RewardTable(file.newID(), file);
        table.setRawTitle(name);
        table.setRawIcon(Items.CHEST.getDefaultInstance());
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            table.addReward(table.makeWeightedItemReward(stack, 1.0f));
        }
        file.addRewardTable(table);
        file.refreshIDMap();
        file.clearCachedData();
        file.markDirty();
        NetworkHelper.sendToAll((MinecraftServer)level.getServer(), (CustomPacketPayload)CreateObjectResponseMessage.create(table, null));
        NetworkHelper.sendToAll((MinecraftServer)level.getServer(), (CustomPacketPayload)SyncTranslationMessageToClient.create((QuestObjectBase)table, file.getLocale(), TranslationKey.TITLE, name));
        source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.command.feedback.table_imported", (Object[])new Object[]{name, table.getWeightedRewards().size()}), false);
        return 1;
    }

    private static int editingMode(CommandSourceStack source, ServerPlayer player, @Nullable Boolean canEdit) {
        return ServerQuestFile.INSTANCE.getTeamData((Player)player).map(data -> {
            boolean newCanEdit = Objects.requireNonNullElse(canEdit, !data.getCanEdit((Player)player));
            data.setCanEdit((Player)player, newCanEdit);
            if (newCanEdit) {
                source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.editing_mode.enabled", (Object[])new Object[]{player.getDisplayName()}), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.editing_mode.disabled", (Object[])new Object[]{player.getDisplayName()}), true);
            }
            return 1;
        }).orElse(0);
    }

    private static int locked(CommandSourceStack source, ServerPlayer player, @Nullable Boolean locked) {
        return ServerQuestFile.INSTANCE.getTeamData((Player)player).map(data -> {
            boolean newLocked = Objects.requireNonNullElse(locked, !data.isLocked());
            data.setLocked(newLocked);
            if (newLocked) {
                source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.locked.enabled", (Object[])new Object[]{player.getDisplayName()}), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.locked.disabled", (Object[])new Object[]{player.getDisplayName()}), true);
            }
            return 1;
        }).orElse(0);
    }

    private static int changeProgress(CommandSourceStack source, Collection<ServerPlayer> players, boolean reset, String idStr) throws CommandSyntaxException {
        QuestObjectBase questObject = FTBQuestsCommands.getQuestObjectForString(idStr);
        for (ServerPlayer player : players) {
            ServerQuestFile.INSTANCE.getTeamData((Player)player).ifPresent(data -> {
                ProgressChange progressChange = new ProgressChange(questObject, player.getUUID()).setReset(reset);
                questObject.forceProgress((TeamData)data, progressChange);
            });
        }
        source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.change_progress.text"), false);
        return 1;
    }

    private static int deleteEmptyRewardTables(CommandSourceStack source) {
        int removed = ServerQuestFile.INSTANCE.removeEmptyRewardTables(source);
        source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.command.delete_empty_reward_tables.text", (Object[])new Object[]{removed}), false);
        return 1;
    }

    private static int generateAllItemChapter(CommandSourceStack source) {
        if (!CreativeModeTabs.searchTab().hasAnyItems()) {
            CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)FeatureFlags.DEFAULT_FLAGS, (boolean)true, (HolderLookup.Provider)source.getLevel().registryAccess());
        }
        Collection allItems = CreativeModeTabs.searchTab().getSearchTabDisplayItems();
        long newId = ServerQuestFile.INSTANCE.newID();
        Chapter chapter = new Chapter(newId, ServerQuestFile.INSTANCE, ServerQuestFile.INSTANCE.getDefaultChapterGroup());
        chapter.onCreated();
        chapter.setRawTitle("Generated chapter of all items in search creative tab [" + allItems.size() + "]");
        chapter.setRawIcon(new ItemStack((ItemLike)Items.COMPASS));
        chapter.setDefaultQuestShape("rsquare");
        NetworkHelper.sendToAll((MinecraftServer)source.getServer(), (CustomPacketPayload)CreateObjectResponseMessage.create(chapter, null));
        List<ItemStack> list = allItems.stream().filter(stack -> !stack.isEmpty() && RegistrarManager.getId((Object)stack.getItem(), (ResourceKey)Registries.ITEM) != null).sorted(Comparator.comparing(a -> RegistrarManager.getId((Object)a.getItem(), (ResourceKey)Registries.ITEM))).toList();
        FTBQuests.LOGGER.info("Found {} items in total, chapter ID: {}", (Object)allItems.size(), (Object)chapter);
        if (list.isEmpty()) {
            return 0;
        }
        int col = 0;
        int row = 0;
        String modid = RegistrarManager.getId((Object)list.getFirst().getItem(), (ResourceKey)Registries.ITEM).getNamespace();
        for (ItemStack stack2 : list) {
            ResourceLocation id = RegistrarManager.getId((Object)stack2.getItem(), (ResourceKey)Registries.ITEM);
            if (!modid.equals(id.getNamespace())) {
                modid = id.getNamespace();
                col = 0;
                row += 2;
            } else if (col >= 40) {
                col = 0;
                ++row;
            }
            Quest quest = new Quest(chapter.file.newID(), chapter);
            quest.onCreated();
            quest.setX(col);
            quest.setY(row);
            quest.setRawSubtitle(stack2.save((HolderLookup.Provider)source.registryAccess(), (Tag)new CompoundTag()).toString());
            NetworkHelper.sendToAll((MinecraftServer)source.getServer(), (CustomPacketPayload)CreateObjectResponseMessage.create(quest, null));
            ItemTask task = new ItemTask(chapter.file.newID(), quest);
            task.onCreated();
            task.setStackAndCount(stack2, 1).setConsumeItems(Tristate.TRUE);
            NetworkHelper.sendToAll((MinecraftServer)source.getServer(), (CustomPacketPayload)CreateObjectMessage.create(task, task.getType().makeExtraNBT()));
            ++col;
        }
        ServerQuestFile.INSTANCE.markDirty();
        ServerQuestFile.INSTANCE.saveNow();
        source.sendSuccess(() -> Component.literal((String)"Done!"), false);
        return 1;
    }

    private static int doReload(CommandSourceStack source, boolean quests, boolean progression) {
        UUID id;
        if (!quests && !progression) {
            return 0;
        }
        ServerQuestFile instance = ServerQuestFile.INSTANCE;
        ServerPlayer sender = source.getPlayer();
        instance.load(quests, progression);
        NetworkHelper.sendToAll((MinecraftServer)source.getServer(), (CustomPacketPayload)new SyncQuestsMessage(instance));
        source.getServer().getPlayerList().getPlayers().forEach(p -> {
            NetworkManager.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)SyncEditorPermissionMessage.forPlayer(p));
            instance.getTranslationManager().sendTranslationsToPlayer((ServerPlayer)p);
        });
        String suffix = quests && progression ? "" : (quests ? "_quest" : "_progress");
        source.sendSuccess(() -> Component.translatable((String)("commands.ftbquests.command.feedback.reloaded" + suffix)), false);
        UUID uUID = id = sender == null ? Util.NIL_UUID : sender.getUUID();
        if (!warnedPlayers.contains(id)) {
            source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.command.feedback.reloaded.disclaimer").withStyle(ChatFormatting.GOLD), false);
            warnedPlayers.add(id);
        }
        return 1;
    }

    private static int toggleRewardBlocking(CommandSourceStack source, ServerPlayer player, Boolean doBlocking) {
        return ServerQuestFile.INSTANCE.getTeamData((Player)player).map(data -> {
            boolean shouldBlock = Objects.requireNonNullElse(doBlocking, !data.areRewardsBlocked());
            data.setRewardsBlocked(shouldBlock);
            source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.command.feedback.rewards_blocked", (Object[])new Object[]{data, data.areRewardsBlocked()}), false);
            return 1;
        }).orElse(0);
    }

    private static int clearDisplayCache(CommandSourceStack source) {
        ClearDisplayCacheMessage.clearForAll(source.getServer());
        source.sendSuccess(() -> Component.translatable((String)"commands.ftbquests.command.feedback.clear_display_cache"), false);
        return 1;
    }
}

