/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import com.mojang.datafixers.util.Pair;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ConfigWithVariants;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.gui.CustomToast;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.client.gui.RewardTablesScreen;
import dev.ftb.mods.ftbquests.client.gui.SelectQuestObjectScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.ChapterImageButton;
import dev.ftb.mods.ftbquests.client.gui.quests.ChapterPanel;
import dev.ftb.mods.ftbquests.client.gui.quests.ExpandChaptersButton;
import dev.ftb.mods.ftbquests.client.gui.quests.OtherButtonsPanelBottom;
import dev.ftb.mods.ftbquests.client.gui.quests.OtherButtonsPanelTop;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestPanel;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestPositionableButton;
import dev.ftb.mods.ftbquests.client.gui.quests.TooltipContextMenuItem;
import dev.ftb.mods.ftbquests.client.gui.quests.ViewQuestPanel;
import dev.ftb.mods.ftbquests.net.ChangeProgressMessage;
import dev.ftb.mods.ftbquests.net.CopyChapterImageMessage;
import dev.ftb.mods.ftbquests.net.CopyQuestMessage;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.text.DateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class QuestScreen
extends BaseScreen {
    public static final int Z_LEVEL = 900;
    final ClientQuestFile file;
    double scrollWidth;
    double scrollHeight;
    int prevMouseX;
    int prevMouseY;
    MouseButton grabbed = null;
    Chapter selectedChapter;
    final List<Movable> selectedObjects;
    final ExpandChaptersButton expandChaptersButton;
    final ChapterPanel chapterPanel;
    boolean movingObjects = false;
    int zoom = 16;
    static boolean grid = false;
    private PersistedData pendingPersistedData;
    private final Deque<Long> questViewHistory = new ArrayDeque<Long>();
    public final QuestPanel questPanel;
    public final OtherButtonsPanelBottom otherButtonsBottomPanel;
    public final OtherButtonsPanelTop otherButtonsTopPanel;
    public final ViewQuestPanel viewQuestPanel;

    public QuestScreen(ClientQuestFile clientQuestFile, @Nullable PersistedData persistedData) {
        this.file = clientQuestFile;
        this.selectedObjects = new ArrayList<Movable>();
        this.expandChaptersButton = new ExpandChaptersButton(this);
        this.chapterPanel = new ChapterPanel((Panel)this);
        this.selectedChapter = this.file.getFirstVisibleChapter(this.file.selfTeamData);
        this.questPanel = new QuestPanel((Panel)this);
        this.otherButtonsBottomPanel = new OtherButtonsPanelBottom((Panel)this);
        this.otherButtonsTopPanel = new OtherButtonsPanelTop((Panel)this);
        this.viewQuestPanel = new ViewQuestPanel(this);
        this.pendingPersistedData = persistedData;
        this.selectChapter(null);
    }

    @Nullable
    public Quest getViewedQuest() {
        return this.viewQuestPanel.getViewedQuest();
    }

    public boolean isViewingQuest() {
        return this.getViewedQuest() != null;
    }

    public void refreshChapterPanel() {
        this.chapterPanel.refreshWidgets();
    }

    public void refreshQuestPanel() {
        this.questPanel.refreshWidgets();
    }

    public void refreshViewQuestPanel() {
        this.viewQuestPanel.refreshWidgets();
    }

    public boolean doesGuiPauseGame() {
        return ClientQuestFile.INSTANCE.isPauseGame();
    }

    public int getMaxZLevel() {
        return 2000;
    }

    public void addWidgets() {
        QuestTheme.currentObject = this.selectedChapter;
        this.add((Widget)this.questPanel);
        this.add((Widget)this.chapterPanel);
        this.add(this.expandChaptersButton);
        this.add((Widget)this.otherButtonsBottomPanel);
        this.add((Widget)this.otherButtonsTopPanel);
    }

    public void alignWidgets() {
        QuestTheme.currentObject = this.selectedChapter;
        this.otherButtonsBottomPanel.alignWidgets();
        this.otherButtonsTopPanel.alignWidgets();
        this.chapterPanel.alignWidgets();
        this.expandChaptersButton.setPosAndSize(0, 0, 20, this.height);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        this.file.setPersistedScreenInfo(this.getPersistedScreenData());
        super.onClosed();
    }

    public void selectChapter(@Nullable Chapter chapter) {
        if (this.selectedChapter != chapter) {
            this.closeQuest();
            this.selectedChapter = chapter;
            this.questPanel.refreshWidgets();
            this.questPanel.resetScroll();
        }
    }

    public void scrollTo(Movable movable) {
        this.questPanel.scrollTo(movable.getX(), movable.getY());
    }

    public void viewQuest(Quest quest) {
        this.viewQuest(quest, true);
    }

    private void viewQuest(Quest quest, boolean addHistory) {
        Quest current = this.viewQuestPanel.getViewedQuest();
        if (current != quest) {
            this.viewQuestPanel.setViewedQuest(quest);
            if (addHistory && quest != null) {
                this.questViewHistory.addFirst(quest.id);
                if (this.questViewHistory.size() > 50) {
                    this.questViewHistory.removeLast();
                }
            }
            if (current == null) {
                this.pushModalPanel(this.viewQuestPanel);
            } else if (quest == null) {
                this.closeModalPanel(this.viewQuestPanel);
            }
            this.viewQuestPanel.updateMouseOver(this.getMouseX(), this.getMouseY());
        }
    }

    public void onBack() {
        if (this.isViewingQuest()) {
            if (((Boolean)FTBQuestsClientConfig.BACKSPACE_HISTORY.get()).booleanValue() && !this.questViewHistory.isEmpty()) {
                QuestObjectBase questObjectBase;
                this.questViewHistory.removeFirst();
                Long prevId = this.questViewHistory.peekFirst();
                if (prevId != null && (questObjectBase = this.file.getBase(prevId)) instanceof Quest) {
                    Quest q = (Quest)questObjectBase;
                    this.viewQuest(q, false);
                } else {
                    this.closeQuest();
                }
            } else {
                this.closeQuest();
            }
        } else {
            super.onBack();
        }
    }

    public void closeQuest() {
        this.viewQuest(null);
    }

    public void toggleSelected(Movable movable) {
        this.viewQuest(null);
        if (this.selectedObjects.contains(movable)) {
            this.selectedObjects.remove(movable);
        } else {
            this.selectedObjects.add(movable);
        }
    }

    public void addObjectMenuItems(List<ContextMenuItem> contextMenu, Runnable gui, QuestObjectBase object, Movable deletionFocus) {
        Component[] componentArray;
        long delId;
        QuestObjectBase delObject;
        RandomReward rr;
        ConfigGroup group = new ConfigGroup("ftbquests");
        ConfigGroup subGroup = object.createSubGroup(group);
        object.fillConfigGroup(subGroup);
        contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), b -> object.onEditButtonClicked(gui)));
        if (object instanceof QuestLink) {
            QuestLink link = (QuestLink)object;
            link.getQuest().ifPresent(quest -> contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.edit_linked_quest"), (Icon)ThemeProperties.EDIT_ICON.get(), b -> quest.onEditButtonClicked(gui))));
        }
        if (!subGroup.getValues().isEmpty()) {
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.copy_id.quick_properties"), Icons.SETTINGS, b -> this.openPropertiesSubMenu(object, subGroup)));
        }
        if (object instanceof RandomReward && !QuestObjectBase.isNull((rr = (RandomReward)object).getTable())) {
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.reward_table.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), b -> rr.getTable().onEditButtonClicked(gui)));
        }
        if ((delObject = ClientQuestFile.INSTANCE.getBase(delId = deletionFocus == null ? object.id : deletionFocus.getMovableID())) != null) {
            ContextMenuItem delete = new ContextMenuItem((Component)Component.translatable((String)"selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), b -> ClientQuestFile.INSTANCE.deleteObject(delId));
            if (!QuestScreen.isShiftKeyDown()) {
                delete.setYesNoText((Component)Component.translatable((String)"delete_item", (Object[])new Object[]{delObject.getTitle()}));
            }
            contextMenu.add(delete);
        }
        contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.reset_progress"), (Icon)ThemeProperties.RELOAD_ICON.get(), b -> ChangeProgressMessage.sendToServer(this.file.selfTeamData, object, progressChange -> progressChange.setReset(true))).setYesNoText((Component)Component.translatable((String)"ftbquests.gui.reset_progress_q")));
        contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.complete_instantly"), (Icon)ThemeProperties.CHECK_ICON.get(), b -> ChangeProgressMessage.sendToServer(this.file.selfTeamData, object, progressChange -> progressChange.setReset(false))).setYesNoText((Component)Component.translatable((String)"ftbquests.gui.complete_instantly_q")));
        if (object instanceof Quest) {
            Component[] componentArray2 = new Component[2];
            componentArray2[0] = Component.literal((String)QuestObjectBase.getCodeString(object));
            componentArray = componentArray2;
            componentArray2[1] = Component.translatable((String)"ftbquests.gui.copy_id.paste_hint").withStyle(ChatFormatting.GRAY);
        } else {
            Component[] componentArray3 = new Component[1];
            componentArray = componentArray3;
            componentArray3[0] = Component.literal((String)QuestObjectBase.getCodeString(object));
        }
        Component[] tooltip = componentArray;
        if (this.selectedChapter != null) {
            if (this.selectedChapter.isAutofocus(object.id)) {
                contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.clear_autofocused"), Icons.MARKER, b -> this.setAutofocusedId(0L)));
            } else if (object instanceof Quest || object instanceof QuestLink) {
                contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.set_autofocused"), Icons.MARKER, b -> this.setAutofocusedId(object.id)));
            }
        }
        contextMenu.add(new TooltipContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.copy_id"), (Icon)ThemeProperties.WIKI_ICON.get(), b -> QuestScreen.setClipboardString((String)object.getCodeString()), tooltip));
    }

    private void setAutofocusedId(long id) {
        this.selectedChapter.setAutofocus(id);
        NetworkManager.sendToServer((CustomPacketPayload)EditObjectMessage.forQuestObject(this.selectedChapter));
    }

    private List<ContextMenuItem> scanForConfigEntries(List<ContextMenuItem> res, final QuestObjectBase object, ConfigGroup g) {
        for (final ConfigValue value : g.getValues()) {
            if (!(value instanceof ConfigWithVariants)) continue;
            MutableComponent name = Component.translatable((String)value.getNameKey());
            if (!value.getCanEdit()) {
                name = name.withStyle(ChatFormatting.GRAY);
            }
            res.add(new ContextMenuItem(this, (Component)name, Icons.SETTINGS, null){

                public void addMouseOverText(TooltipList list) {
                    list.add(value.getStringForGUI());
                }

                public void onClicked(Button button, Panel panel, MouseButton mouseButton) {
                    value.onClicked((Widget)button, mouseButton, accepted -> {
                        if (accepted) {
                            value.applyValue();
                            NetworkManager.sendToServer((CustomPacketPayload)EditObjectMessage.forQuestObject(object));
                        }
                    });
                }

                public void drawIcon(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                    value.getIcon().draw(graphics, x, y, w, h);
                }
            });
        }
        for (ConfigGroup sub : g.getSubgroups()) {
            this.scanForConfigEntries(res, object, sub);
        }
        return res;
    }

    private void openPropertiesSubMenu(QuestObjectBase object, ConfigGroup g) {
        ArrayList<ContextMenuItem> subMenu = new ArrayList<ContextMenuItem>();
        subMenu.add(new ContextMenuItem(object.getTitle(), (Icon)Color4I.empty(), null).setCloseMenu(false));
        subMenu.add(ContextMenuItem.SEPARATOR);
        subMenu.addAll(this.scanForConfigEntries(new ArrayList<ContextMenuItem>(), object, g));
        this.getGui().openContextMenu(subMenu);
    }

    public static void displayError(Component error) {
        Minecraft.getInstance().getToasts().addToast((Toast)new CustomToast((Component)Component.translatable((String)"ftbquests.gui.error"), Icons.BARRIER, error));
    }

    private boolean moveSelectedQuests(double x, double y) {
        for (Movable movable : this.selectedObjects) {
            if (movable.getChapter() != this.selectedChapter) continue;
            movable.initiateMoveClientSide(this.selectedChapter, movable.getX() + x, movable.getY() + y);
        }
        return true;
    }

    private boolean copyObjectsToClipboard() {
        Movable toCopy = null;
        if (this.selectedObjects.size() > 1) {
            QuestScreen.displayError((Component)Component.translatable((String)"ftbquests.quest.cannot_copy_many"));
        } else {
            toCopy = this.selectedObjects.isEmpty() ? (Movable)this.questPanel.getWidgets().stream().filter(w -> w instanceof QuestPositionableButton && w.isMouseOver()).map(w -> ((QuestPositionableButton)w).moveAndDeleteFocus()).findFirst().orElse(null) : this.selectedObjects.getFirst();
        }
        if (toCopy != null) {
            toCopy.copyToClipboard();
            Minecraft.getInstance().getToasts().addToast((Toast)new CustomToast((Component)Component.translatable((String)"ftbquests.quest.copied"), Icons.INFO, (Component)Component.literal((String)toCopy.getTitle().getString())));
            return true;
        }
        return false;
    }

    private boolean pasteSelectedQuest(boolean withDeps) {
        if (ChapterImage.isImageInClipboard()) {
            return this.pasteSelectedImage();
        }
        return QuestObjectBase.parseHexId(QuestScreen.getClipboardString()).map(id -> {
            Quest quest = this.file.getQuest((long)id);
            if (quest == null) {
                return false;
            }
            Pair<Double, Double> qxy = this.getSnappedXY();
            NetworkManager.sendToServer((CustomPacketPayload)new CopyQuestMessage(quest.id, this.selectedChapter.id, (Double)qxy.getFirst(), (Double)qxy.getSecond(), withDeps));
            return true;
        }).orElse(false);
    }

    private boolean pasteSelectedImage() {
        return ChapterImageButton.getClipboardImage().map(clipImg -> {
            Pair<Double, Double> qxy = this.getSnappedXY();
            NetworkManager.sendToServer((CustomPacketPayload)new CopyChapterImageMessage((ChapterImage)clipImg, this.selectedChapter, (Double)qxy.getFirst(), (Double)qxy.getSecond()));
            return true;
        }).orElse(false);
    }

    private boolean pasteSelectedQuestLinks() {
        String clip = QuestScreen.getClipboardString();
        if (clip.isEmpty()) {
            return false;
        }
        return QuestObjectBase.parseHexId(clip).map(id -> {
            if (this.file.getQuest((long)id) == null) {
                return false;
            }
            Pair<Double, Double> qxy = this.getSnappedXY();
            QuestLink link = new QuestLink(0L, this.selectedChapter, (long)id);
            link.setPosition((Double)qxy.getFirst(), (Double)qxy.getSecond());
            NetworkManager.sendToServer((CustomPacketPayload)CreateObjectMessage.create(link, null, false));
            return true;
        }).orElse(false);
    }

    private Pair<Double, Double> getSnappedXY() {
        double snap = 1.0 / this.file.getGridScale();
        double qx = (double)Mth.floor((double)(this.questPanel.questX * snap + 0.5)) / snap;
        double qy = (double)Mth.floor((double)(this.questPanel.questY * snap + 0.5)) / snap;
        return Pair.of((Object)qx, (Object)qy);
    }

    void deleteSelectedObjects() {
        this.selectedObjects.forEach(movable -> {
            if (movable instanceof Quest) {
                Quest q = (Quest)movable;
                this.file.deleteObject(q.id);
            } else if (movable instanceof QuestLink) {
                QuestLink ql = (QuestLink)movable;
                this.file.deleteObject(ql.id);
            } else if (movable instanceof ChapterImage) {
                ChapterImage img = (ChapterImage)movable;
                img.getChapter().removeImage(img);
                NetworkManager.sendToServer((CustomPacketPayload)EditObjectMessage.forQuestObject(img.getChapter()));
            }
        });
        this.selectedObjects.clear();
    }

    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if (FTBQuestsClient.KEY_QUESTS.matches(key.keyCode, key.scanCode)) {
            this.closeGui(true);
            return true;
        }
        List<Chapter> visibleChapters = this.file.getVisibleChapters(this.file.selfTeamData);
        if (key.is(258)) {
            if (this.selectedChapter != null && visibleChapters.size() > 1) {
                this.selectChapter(visibleChapters.get(MathUtils.mod((int)(visibleChapters.indexOf(this.selectedChapter) + (QuestScreen.isShiftKeyDown() ? -1 : 1)), (int)visibleChapters.size())));
                this.selectedChapter.getAutofocus().ifPresent(this::scrollTo);
            }
            return true;
        }
        if (key.is(32)) {
            this.questPanel.resetScroll();
            return true;
        }
        if (key.is(82) && key.modifiers.onlyControl()) {
            grid = !grid;
            return true;
        }
        if (key.is(70) && key.modifiers.onlyControl()) {
            this.openQuestSelectionGUI();
            return true;
        }
        if (key.is(48)) {
            this.addZoom((double)(16 - this.zoom) / 4.0);
            return true;
        }
        if (key.keyCode >= 49 && key.keyCode <= 57) {
            int i = key.keyCode - 49;
            if (i < visibleChapters.size()) {
                this.selectChapter(visibleChapters.get(i));
                this.selectedChapter.getAutofocus().ifPresent(this::scrollTo);
            }
            return true;
        }
        if (!this.file.canEdit()) {
            return false;
        }
        if (key.is(261) && !this.selectedObjects.isEmpty()) {
            if (!QuestScreen.isShiftKeyDown()) {
                MutableComponent title = Component.translatable((String)"delete_item", (Object[])new Object[]{Component.translatable((String)"ftbquests.objects", (Object[])new Object[]{this.selectedObjects.size()})});
                this.getGui().openYesNo((Component)title, (Component)Component.empty(), this::deleteSelectedObjects);
            } else {
                this.deleteSelectedObjects();
            }
        } else if (key.modifiers.control()) {
            double step = key.modifiers.shift() ? 0.1 : 0.5;
            switch (key.keyCode) {
                case 65: {
                    if (this.selectedChapter != null) {
                        this.selectedObjects.addAll(this.selectedChapter.getQuests());
                        this.selectedObjects.addAll(this.selectedChapter.getQuestLinks());
                        this.selectedObjects.addAll(this.selectedChapter.getImages());
                    }
                    return true;
                }
                case 68: {
                    this.selectedObjects.clear();
                    return true;
                }
                case 264: {
                    return this.moveSelectedQuests(0.0, step);
                }
                case 265: {
                    return this.moveSelectedQuests(0.0, -step);
                }
                case 263: {
                    return this.moveSelectedQuests(-step, 0.0);
                }
                case 262: {
                    return this.moveSelectedQuests(step, 0.0);
                }
                case 67: {
                    return this.copyObjectsToClipboard();
                }
                case 86: {
                    if (key.modifiers.alt()) {
                        return this.pasteSelectedQuestLinks();
                    }
                    return this.pasteSelectedQuest(!key.modifiers.shift());
                }
                case 84: {
                    if (!key.modifiers.control()) break;
                    new RewardTablesScreen(this).openGui();
                    return true;
                }
            }
        }
        return false;
    }

    private void openQuestSelectionGUI() {
        ConfigQuestObject c = new ConfigQuestObject(QuestObjectType.CHAPTER.or(QuestObjectType.QUEST).or(QuestObjectType.QUEST_LINK));
        new SelectQuestObjectScreen(c, accepted -> {
            if (accepted) {
                Object patt0$temp = c.getValue();
                if (patt0$temp instanceof Chapter) {
                    Chapter chapter = (Chapter)patt0$temp;
                    this.selectChapter(chapter);
                } else {
                    Object patt1$temp = c.getValue();
                    if (patt1$temp instanceof Quest) {
                        Quest quest = (Quest)patt1$temp;
                        this.zoom = 20;
                        this.selectChapter(quest.getChapter());
                        this.questPanel.scrollTo(quest.getX(), quest.getY());
                        this.viewQuest(quest);
                    } else {
                        Object patt2$temp = c.getValue();
                        if (patt2$temp instanceof QuestLink) {
                            QuestLink link = (QuestLink)patt2$temp;
                            this.zoom = 20;
                            this.selectChapter(link.getChapter());
                            this.questPanel.scrollTo(link.getX(), link.getY());
                            link.getQuest().ifPresent(this::viewQuest);
                        }
                    }
                }
            }
            this.openGui();
        }).openGui();
    }

    public void tick() {
        if (this.pendingPersistedData != null) {
            this.restorePersistedScreenData(this.file, this.pendingPersistedData);
            this.pendingPersistedData = null;
        }
        if (this.selectedChapter != null && !this.selectedChapter.isValid()) {
            this.selectChapter(null);
        }
        if (this.selectedChapter == null) {
            this.selectChapter(this.file.getFirstVisibleChapter(this.file.selfTeamData));
            if (this.selectedChapter != null) {
                this.selectedChapter.getAutofocus().ifPresent(this::scrollTo);
            }
        }
        super.tick();
    }

    public int getZoom() {
        return this.zoom;
    }

    public double getQuestButtonSize() {
        return (double)this.getZoom() * 3.0 / 2.0;
    }

    public double getQuestButtonSpacing() {
        return (double)this.getZoom() * (Double)ThemeProperties.QUEST_SPACING.get(this.selectedChapter) / 4.0;
    }

    public void addZoom(double up) {
        int z = this.zoom;
        this.zoom = (int)Mth.clamp((double)((double)this.zoom + up * 4.0), (double)4.0, (double)28.0);
        if (this.zoom != z) {
            this.grabbed = null;
            this.questPanel.withPreservedPos(QuestPanel::resetScroll);
        }
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        QuestTheme.currentObject = this.selectedChapter;
        super.drawBackground(graphics, theme, x, y, w, h);
        int pw = 20;
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.selectedChapter);
        Color4I backgroundColor = (Color4I)ThemeProperties.WIDGET_BACKGROUND.get(this.selectedChapter);
        if (!this.chapterPanel.expanded) {
            borderColor.draw(graphics, x + pw - 1, y + 1, 1, h - 2);
            backgroundColor.draw(graphics, x + 1, y + 1, pw - 2, h - 2);
        }
        borderColor.draw(graphics, x + w - pw, y + 1, 1, h - 2);
        backgroundColor.draw(graphics, x + w - pw + 1, y + 1, pw - 2, h - 2);
        if (this.grabbed != null) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.grabbed.isLeft()) {
                if (this.scrollWidth > (double)this.questPanel.width) {
                    this.questPanel.setScrollX(Math.max(Math.min(this.questPanel.getScrollX() + (double)(this.prevMouseX - mx), this.scrollWidth - (double)this.questPanel.width), 0.0));
                } else {
                    this.questPanel.setScrollX((this.scrollWidth - (double)this.questPanel.width) / 2.0);
                }
                if (this.scrollHeight > (double)this.questPanel.height) {
                    this.questPanel.setScrollY(Math.max(Math.min(this.questPanel.getScrollY() + (double)(this.prevMouseY - my), this.scrollHeight - (double)this.questPanel.height), 0.0));
                } else {
                    this.questPanel.setScrollY((this.scrollHeight - (double)this.questPanel.height) / 2.0);
                }
                this.prevMouseX = mx;
                this.prevMouseY = my;
            } else if (this.grabbed.isMiddle()) {
                int boxX = Math.min(this.prevMouseX, mx);
                int boxY = Math.min(this.prevMouseY, my);
                int boxW = Math.abs(mx - this.prevMouseX);
                int boxH = Math.abs(my - this.prevMouseY);
                GuiHelper.drawHollowRect((GuiGraphics)graphics, (int)boxX, (int)boxY, (int)boxW, (int)boxH, (Color4I)Color4I.DARK_GRAY, (boolean)false);
                Color4I.DARK_GRAY.withAlpha(40).draw(graphics, boxX, boxY, boxW, boxH);
            }
        }
    }

    void selectAllQuestsInBox(int mouseX, int mouseY, double scrollX, double scrollY) {
        int x1 = Math.min(this.prevMouseX, mouseX);
        int x2 = Math.max(this.prevMouseX, mouseX);
        int y1 = Math.min(this.prevMouseY, mouseY);
        int y2 = Math.max(this.prevMouseY, mouseY);
        Rect2i rect = new Rect2i(x1, y1, x2 - x1, y2 - y1);
        if (!Screen.hasControlDown()) {
            this.selectedObjects.clear();
        }
        this.questPanel.getWidgets().forEach(w -> {
            if (w instanceof QuestPositionableButton) {
                QuestPositionableButton qb = (QuestPositionableButton)w;
                if (rect.contains((int)((double)w.getX() - scrollX), (int)((double)w.getY() - scrollY))) {
                    this.toggleSelected(qb.moveAndDeleteFocus());
                }
            }
        });
    }

    public void drawForeground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.selectedChapter);
        GuiHelper.drawHollowRect((GuiGraphics)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)borderColor, (boolean)false);
        super.drawForeground(graphics, theme, x, y, w, h);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public boolean drawDefaultBackground(GuiGraphics graphics) {
        return false;
    }

    public void open(@Nullable QuestObject object, boolean focus) {
        if (object instanceof Chapter) {
            Chapter chapter = (Chapter)object;
            this.selectChapter(chapter);
        } else if (object instanceof Quest) {
            Quest quest2 = (Quest)object;
            this.selectChapter(quest2.getChapter());
            this.viewQuest(quest2);
            if (focus) {
                this.questPanel.scrollTo(quest2.getX() + 0.5, quest2.getY() + 0.5);
            }
        } else if (object instanceof QuestLink) {
            QuestLink link = (QuestLink)object;
            link.getQuest().ifPresent(quest -> {
                this.selectChapter(link.getChapter());
                this.viewQuest((Quest)quest);
                if (focus) {
                    this.questPanel.scrollTo(link.getX() + 0.5, link.getY() + 0.5);
                }
            });
        } else if (object instanceof Task) {
            Task task = (Task)object;
            this.selectChapter(task.getQuest().getChapter());
            this.viewQuest(task.getQuest());
        }
        this.pendingPersistedData = null;
        if (ClientUtils.getCurrentGuiAs(QuestScreen.class) != this) {
            this.openGui();
        }
    }

    public boolean handleClick(String scheme, String path) {
        if (scheme.isEmpty() && path.startsWith("#")) {
            this.open(this.file.get(this.file.getID(path)), true);
            return true;
        }
        return super.handleClick(scheme, path);
    }

    public void addMouseOverText(TooltipList list) {
        super.addMouseOverText(list);
    }

    public void addInfoTooltip(TooltipList list, QuestObjectBase object) {
        if (QuestScreen.isKeyDown((int)290) || QuestScreen.isShiftKeyDown() && QuestScreen.isCtrlKeyDown()) {
            list.add((Component)Component.literal((String)object.getCodeString()).withStyle(ChatFormatting.DARK_GRAY));
            if (object instanceof QuestObject) {
                this.file.selfTeamData.getStartedTime(object.id).ifPresent(date -> list.add(QuestScreen.formatDate("Started", date)));
                this.file.selfTeamData.getCompletedTime(object.id).ifPresent(date -> list.add(QuestScreen.formatDate("Completed", date)));
            } else if (object instanceof Reward) {
                Reward r = (Reward)object;
                this.file.selfTeamData.getRewardClaimTime(FTBQuestsClient.getClientPlayer().getUUID(), r).ifPresent(date -> list.add(QuestScreen.formatDate("Claimed", date)));
            }
        }
    }

    private static Component formatDate(String prefix, Date date) {
        return Component.literal((String)(prefix + ": ")).append((Component)Component.literal((String)DateFormat.getDateTimeInstance().format(date)).withStyle(ChatFormatting.DARK_GRAY));
    }

    public Collection<Quest> getSelectedQuests() {
        HashMap questMap = new HashMap();
        this.selectedObjects.forEach(movable -> {
            if (movable instanceof Quest) {
                Quest q2 = (Quest)movable;
                questMap.put(q2.id, q2);
            } else if (movable instanceof QuestLink) {
                QuestLink ql = (QuestLink)movable;
                ql.getQuest().ifPresent(q -> questMap.put(q.id, q));
            }
        });
        return List.copyOf(questMap.values());
    }

    public PersistedData getPersistedScreenData() {
        return this.pendingPersistedData != null ? this.pendingPersistedData : new PersistedData(this);
    }

    private void restorePersistedScreenData(BaseQuestFile file, PersistedData persistedData) {
        this.zoom = persistedData.zoom;
        this.selectChapter(file.getChapter(persistedData.selectedChapter));
        this.selectedObjects.clear();
        persistedData.selectedQuests.stream().mapToLong(id -> id).filter(id -> file.get(id) instanceof Movable).mapToObj(id -> (Movable)((Object)file.get(id))).forEach(this.selectedObjects::add);
        this.questPanel.scrollTo(persistedData.scrollX, persistedData.scrollY);
        this.questPanel.centerQuestX = persistedData.scrollX;
        this.questPanel.centerQuestY = persistedData.scrollY;
        this.chapterPanel.setExpanded(persistedData.chaptersExpanded);
        this.questViewHistory.clear();
        this.questViewHistory.addAll(persistedData.questViewHistory);
    }

    public void initiateMoving(Movable movable) {
        this.movingObjects = true;
        this.selectedObjects.clear();
        this.toggleSelected(movable);
    }

    public static class PersistedData {
        private final int zoom;
        private final double scrollX;
        private final double scrollY;
        private final long selectedChapter;
        private final List<Long> selectedQuests;
        private final boolean chaptersExpanded;
        private final Deque<Long> questViewHistory;

        private PersistedData(QuestScreen questScreen) {
            this.zoom = questScreen.zoom;
            this.scrollX = questScreen.questPanel.centerQuestX;
            this.scrollY = questScreen.questPanel.centerQuestY;
            this.selectedChapter = questScreen.selectedChapter == null ? 0L : questScreen.selectedChapter.id;
            this.selectedQuests = questScreen.selectedObjects.stream().map(Movable::getMovableID).filter(id -> id != 0L).toList();
            this.chaptersExpanded = questScreen.chapterPanel.expanded;
            this.questViewHistory = new ArrayDeque<Long>(questScreen.questViewHistory);
        }
    }
}

