/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.simple;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.DirectionMaps;
import me.pepperbell.continuity.client.processor.OrientationMode;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.OrientedConnectingCtmProperties;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class VerticalSpriteProvider
implements SpriteProvider {
    protected static final int[] SPRITE_INDEX_MAP = new int[]{3, 2, 0, 1};
    protected TextureAtlasSprite[] sprites;
    protected ConnectionPredicate connectionPredicate;
    protected boolean innerSeams;
    protected OrientationMode orientationMode;

    public VerticalSpriteProvider(TextureAtlasSprite[] sprites, ConnectionPredicate connectionPredicate, boolean innerSeams, OrientationMode orientationMode) {
        this.sprites = sprites;
        this.connectionPredicate = connectionPredicate;
        this.innerSeams = innerSeams;
        this.orientationMode = orientationMode;
    }

    @Override
    @Nullable
    public TextureAtlasSprite getSprite(QuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, ProcessingDataProvider dataProvider) {
        Direction[] directions = DirectionMaps.getDirections(this.orientationMode, quad, appearanceState);
        BlockPos.MutableBlockPos mutablePos = dataProvider.getData(ProcessingDataKeys.MUTABLE_POS);
        int connections = this.getConnections(directions, mutablePos, blockView, appearanceState, state, pos, quad.lightFace(), sprite);
        return this.sprites[SPRITE_INDEX_MAP[connections]];
    }

    protected int getConnections(Direction[] directions, BlockPos.MutableBlockPos mutablePos, BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, Direction face, TextureAtlasSprite quadSprite) {
        int connections = 0;
        for (int i = 0; i < 2; ++i) {
            mutablePos.setWithOffset((Vec3i)pos, directions[i * 2 + 1]);
            if (!this.connectionPredicate.shouldConnect(blockView, appearanceState, state, pos, mutablePos, face, quadSprite, this.innerSeams)) continue;
            connections |= 1 << i;
        }
        return connections;
    }

    public static class Factory
    implements SpriteProvider.Factory<OrientedConnectingCtmProperties> {
        @Override
        public SpriteProvider createSpriteProvider(TextureAtlasSprite[] sprites, OrientedConnectingCtmProperties properties) {
            return new VerticalSpriteProvider(sprites, properties.getConnectionPredicate(), properties.getInnerSeams(), properties.getOrientationMode());
        }

        @Override
        public int getTextureAmount(OrientedConnectingCtmProperties properties) {
            return 4;
        }
    }
}

