/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import me.pepperbell.continuity.api.client.CachingPredicates;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BaseCachingPredicates
implements CachingPredicates {
    @Nullable
    protected Set<ResourceLocation> spriteIdSet;
    @Nullable
    protected Predicate<BlockState> blockStatePredicate;
    protected boolean isValidForMultipass;

    public BaseCachingPredicates(@Nullable Set<ResourceLocation> spriteIdSet, @Nullable Predicate<BlockState> blockStatePredicate, boolean isValidForMultipass) {
        this.spriteIdSet = spriteIdSet;
        this.blockStatePredicate = blockStatePredicate;
        this.isValidForMultipass = isValidForMultipass;
    }

    @Override
    public boolean affectsSprites() {
        return this.spriteIdSet != null;
    }

    @Override
    public boolean affectsSprite(TextureAtlasSprite sprite) {
        if (this.spriteIdSet != null) {
            return this.spriteIdSet.contains(sprite.contents().name());
        }
        return false;
    }

    @Override
    public boolean affectsBlockStates() {
        return this.blockStatePredicate != null;
    }

    @Override
    public boolean affectsBlockState(BlockState state) {
        if (this.blockStatePredicate != null) {
            return this.blockStatePredicate.test(state);
        }
        return false;
    }

    @Override
    public boolean isValidForMultipass() {
        return this.isValidForMultipass;
    }

    public static class Factory<T extends BaseCtmProperties>
    implements CachingPredicates.Factory<T> {
        protected boolean isValidForMultipass;

        public Factory(boolean isValidForMultipass) {
            this.isValidForMultipass = isValidForMultipass;
        }

        @Override
        public CachingPredicates createPredicates(T properties, Function<Material, TextureAtlasSprite> textureGetter) {
            return new BaseCachingPredicates(((BaseCtmProperties)properties).getMatchTilesSet(), ((BaseCtmProperties)properties).getMatchBlocksPredicate(), this.isValidForMultipass);
        }
    }
}

