/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.online_emotes.netty.compression;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.List;
import net.minecraft.network.VarInt;
import org.redlance.dima_dencep.mods.online_emotes.OnlineEmotesConfig;

public class VelocityCompressEncoder
extends MessageToMessageEncoder<WebSocketFrame> {
    public static final String NAME = "velocity-compressor";
    private final VelocityCompressor compressor;

    public VelocityCompressEncoder(VelocityCompressor compressor) {
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        int uncompressed = msg.content().readableBytes();
        if (uncompressed == 0) {
            out.add(msg.retain());
            return;
        }
        ByteBuf allocated = this.allocateBuffer(ctx, msg.content());
        if (uncompressed < OnlineEmotesConfig.compressionThreshold()) {
            VarInt.write((ByteBuf)allocated, (int)0);
            allocated.writeBytes(msg.content());
        } else {
            VarInt.write((ByteBuf)allocated, (int)uncompressed);
            ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (ByteBuf)msg.content());
            try {
                this.compressor.deflate(compatibleIn, allocated);
            }
            finally {
                compatibleIn.release();
            }
        }
        out.add(msg.replace(allocated));
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg) {
        int initialBufferSize = msg.readableBytes() + 1;
        return MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (int)initialBufferSize);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.compressor.close();
    }
}

