/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.worldgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class DefaultCropsFeature
extends Feature<RandomPatchConfiguration> {
    public DefaultCropsFeature(Codec<RandomPatchConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<RandomPatchConfiguration> pContext) {
        WorldGenLevel level = pContext.level();
        ChunkGenerator generator = pContext.chunkGenerator();
        BlockPos pos = pContext.origin();
        RandomSource random = pContext.random();
        RandomPatchConfiguration config = (RandomPatchConfiguration)pContext.config();
        FeatureConfiguration featureConfig = ((ConfiguredFeature)((PlacedFeature)config.feature().value()).feature().value()).config();
        if (!(featureConfig instanceof SimpleBlockConfiguration)) {
            return false;
        }
        BlockState state = ((SimpleBlockConfiguration)featureConfig).toPlace().getState(random, pos);
        int i = 0;
        for (int j = 0; j < config.tries(); ++j) {
            BlockPos blockpos = this.getPos(random, pos, config);
            if (state.getBlock() instanceof SimpleWaterloggedBlock) {
                if (!level.getBlockState(blockpos).is(Blocks.WATER) || blockpos.getY() >= 255 || !state.canSurvive((LevelReader)level, blockpos)) continue;
                ((PlacedFeature)config.feature().value()).place(level, generator, random, blockpos);
                ++i;
                continue;
            }
            if (!level.isEmptyBlock(blockpos) || blockpos.getY() >= 255 || !state.canSurvive((LevelReader)level, blockpos)) continue;
            ((PlacedFeature)config.feature().value()).place(level, generator, random, blockpos);
            ++i;
        }
        return i > 0;
    }

    public BlockPos getPos(RandomSource random, BlockPos pos, RandomPatchConfiguration config) {
        return pos.offset(random.nextInt(config.xzSpread()) - random.nextInt(config.xzSpread()), random.nextInt(config.ySpread()) - random.nextInt(config.ySpread()), random.nextInt(config.xzSpread()) - random.nextInt(config.xzSpread()));
    }
}

