/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.util;

import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.dawnoftimebuilder.registry.DoTBBlocksRegistry;
import org.dawnoftimebuilder.registry.DoTBItemsRegistry;
import org.jetbrains.annotations.NotNull;

public class BlockStatePropertiesAA {
    public static final BooleanProperty CUT = BooleanProperty.create((String)"cut");
    public static final BooleanProperty ROLLED = BooleanProperty.create((String)"rolled");
    public static final BooleanProperty AXIS_X = BooleanProperty.create((String)"axis_x");
    public static final BooleanProperty AXIS_Y = BooleanProperty.create((String)"axis_y");
    public static final BooleanProperty AXIS_Z = BooleanProperty.create((String)"axis_z");
    public static final BooleanProperty SUBAXIS = BooleanProperty.create((String)"subaxis");
    public static final BooleanProperty HAS_PILLAR = BooleanProperty.create((String)"has_pillar");
    public static final BooleanProperty CENTER = BooleanProperty.create((String)"center");
    public static final BooleanProperty NORTH_TRICKLE = BooleanProperty.create((String)"north_trickle");
    public static final BooleanProperty EAST_TRICKLE = BooleanProperty.create((String)"east_trickle");
    public static final BooleanProperty SOUTH_TRICKLE = BooleanProperty.create((String)"south_trickle");
    public static final BooleanProperty WEST_TRICKLE = BooleanProperty.create((String)"west_trickle");
    public static final BooleanProperty CENTER_TRICKLE = BooleanProperty.create((String)"center_trickle");
    public static final BooleanProperty ACTIVATED = BooleanProperty.create((String)"activated");
    public static final BooleanProperty SMALL_TOP = BooleanProperty.create((String)"small_top");
    public static final IntegerProperty MULTIBLOCK_0_2 = IntegerProperty.create((String)"multiblock", (int)0, (int)2);
    public static final IntegerProperty MULTIBLOCK_3X = IntegerProperty.create((String)"multiblock_3x", (int)0, (int)2);
    public static final IntegerProperty MULTIBLOCK_2Y = IntegerProperty.create((String)"multiblock_2y", (int)0, (int)1);
    public static final IntegerProperty MULTIBLOCK_3Z = IntegerProperty.create((String)"multiblock_3z", (int)0, (int)2);
    public static final IntegerProperty HUMIDITY_0_8 = IntegerProperty.create((String)"humidity", (int)0, (int)8);
    public static final IntegerProperty AGE_0_6 = IntegerProperty.create((String)"age", (int)0, (int)6);
    public static final IntegerProperty HEAT_0_4 = IntegerProperty.create((String)"heat", (int)0, (int)4);
    public static final IntegerProperty SIZE_0_2 = IntegerProperty.create((String)"size", (int)0, (int)2);
    public static final IntegerProperty SIZE_0_5 = IntegerProperty.create((String)"size", (int)0, (int)5);
    public static final IntegerProperty STACK = IntegerProperty.create((String)"stack", (int)1, (int)3);
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)16);
    public static final EnumProperty<ClimbingPlant> CLIMBING_PLANT = EnumProperty.create((String)"climbing_plant", ClimbingPlant.class);
    public static final EnumProperty<FencePillar> FENCE_PILLAR = EnumProperty.create((String)"fence_pillar", FencePillar.class);
    public static final EnumProperty<HorizontalConnection> HORIZONTAL_CONNECTION = EnumProperty.create((String)"horizontal_connection", HorizontalConnection.class);
    public static final EnumProperty<OpenPosition> OPEN_POSITION = EnumProperty.create((String)"open_position", OpenPosition.class);
    public static final EnumProperty<PillarConnection> PILLAR_CONNECTION = EnumProperty.create((String)"pillar_connection", PillarConnection.class);
    public static final EnumProperty<SidedWindow> SIDED_WINDOW = EnumProperty.create((String)"sided_window", SidedWindow.class);
    public static final EnumProperty<VerticalConnection> VERTICAL_CONNECTION = EnumProperty.create((String)"vertical_connection", VerticalConnection.class);
    public static final EnumProperty<SquareCorners> CORNER = EnumProperty.create((String)"corner", SquareCorners.class);
    public static final EnumProperty<WallSide> PILLAR_WALL = EnumProperty.create((String)"pillar", WallSide.class);
    public static final EnumProperty<VerticalLimitedConnection> NORTH_STATE = EnumProperty.create((String)"north_state", VerticalLimitedConnection.class);
    public static final EnumProperty<VerticalLimitedConnection> EAST_STATE = EnumProperty.create((String)"east_state", VerticalLimitedConnection.class);
    public static final EnumProperty<VerticalLimitedConnection> SOUTH_STATE = EnumProperty.create((String)"south_state", VerticalLimitedConnection.class);
    public static final EnumProperty<VerticalLimitedConnection> WEST_STATE = EnumProperty.create((String)"west_state", VerticalLimitedConnection.class);
    public static final EnumProperty<WaterTrickleEnd> WATER_TRICKLE_END = EnumProperty.create((String)"water_end", WaterTrickleEnd.class);

    public static enum ClimbingPlant implements StringRepresentable
    {
        NONE("none"),
        VINE("vine"),
        IVY("ivy"),
        GRAPE("grape", true, 4, 6, 0, 2, 2);

        private final String name;
        private final boolean cycle;
        private final int[] moonPhasePerAge;

        private ClimbingPlant(String name, boolean cycle, int age2, int age3, int age4, int age5, int age6) {
            this.name = name;
            this.cycle = cycle;
            this.moonPhasePerAge = new int[]{age2, age3, age4, age5, age6};
        }

        private ClimbingPlant(String name) {
            this(name, false, 0, 0, 0, 0, 0);
        }

        public static ClimbingPlant getFromItem(Item item) {
            if (item == DoTBItemsRegistry.INSTANCE.GRAPE_SEEDS.get()) {
                return GRAPE;
            }
            if (item == Blocks.VINE.asItem()) {
                return VINE;
            }
            if (item == DoTBBlocksRegistry.INSTANCE.IVY.get().asItem()) {
                return IVY;
            }
            return NONE;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public int maxAge() {
            return this.cycle ? 6 : 2;
        }

        public boolean canGrow(Level worldIn, int currentAge) {
            if (!this.cycle || currentAge < 2 || currentAge > 6) {
                return false;
            }
            int currentPhase = worldIn.dimensionType().moonPhase(worldIn.getDayTime());
            return (currentPhase - this.moonPhasePerAge[currentAge -= 2] + 8) % 8 < 4;
        }

        public boolean hasNoPlant() {
            return this == NONE;
        }
    }

    public static enum FencePillar implements StringRepresentable
    {
        NONE("none"),
        PILLAR_BIG("pillar_big"),
        PILLAR_SMALL("pillar_small"),
        CAP_PILLAR_BIG("cap_pillar_big");

        private final String name;

        private FencePillar(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum HorizontalConnection implements StringRepresentable
    {
        NONE("none", 0),
        LEFT("left", 1),
        RIGHT("right", 2),
        BOTH("both", 3);

        private final String name;
        private final int index;

        private HorizontalConnection(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum OpenPosition implements StringRepresentable
    {
        CLOSED("closed"),
        HALF("half"),
        FULL("full");

        private final String name;

        private OpenPosition(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public boolean isOpen() {
            return this != CLOSED;
        }
    }

    public static enum PillarConnection implements StringRepresentable
    {
        NOTHING("nothing"),
        FOUR_PX("4_pixels"),
        SIX_PX("6_pixels"),
        EIGHT_PX("8_pixels"),
        TEN_PX("10_pixels");

        private final String name;

        private PillarConnection(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum SidedWindow implements StringRepresentable
    {
        NORTH("north", Direction.NORTH),
        EAST("east", Direction.EAST),
        SOUTH("south", Direction.SOUTH),
        WEST("west", Direction.WEST),
        AXIS_X("axis_x", Direction.EAST),
        AXIS_Z("axis_z", Direction.NORTH);

        private final String name;
        private final Direction direction;

        private SidedWindow(String name, Direction offset) {
            this.name = name;
            this.direction = offset;
        }

        public static SidedWindow getSide(Direction facing, boolean isSneaking) {
            if (isSneaking) {
                return facing.getAxis() == Direction.Axis.X ? AXIS_X : AXIS_Z;
            }
            return switch (facing) {
                case Direction.EAST -> EAST;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                default -> NORTH;
            };
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public Direction getOffset() {
            return this.direction.getCounterClockWise();
        }

        public SidedWindow rotate(boolean clockWise) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (clockWise) {
                        yield EAST;
                    }
                    yield WEST;
                }
                case 1 -> {
                    if (clockWise) {
                        yield SOUTH;
                    }
                    yield NORTH;
                }
                case 2 -> {
                    if (clockWise) {
                        yield WEST;
                    }
                    yield EAST;
                }
                case 3 -> {
                    if (clockWise) {
                        yield NORTH;
                    }
                    yield SOUTH;
                }
                case 4 -> AXIS_Z;
                case 5 -> AXIS_X;
            };
        }
    }

    public static enum VerticalConnection implements StringRepresentable
    {
        NONE("none", 0),
        UNDER("under", 1),
        ABOVE("above", 2),
        BOTH("both", 3);

        private final String name;
        private final int index;

        private VerticalConnection(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum SquareCorners implements StringRepresentable
    {
        TOP_LEFT("top_left", -1, 1),
        TOP_RIGHT("top_right", 1, 1),
        BOTTOM_RIGHT("bottom_right", 1, -1),
        BOTTOM_LEFT("bottom_left", -1, -1);

        private final String name;
        private final int horizontal_offset;
        private final int vertical_offset;

        private SquareCorners(String name, int horizontal_offset, int vertical_offset) {
            this.name = name;
            this.horizontal_offset = horizontal_offset;
            this.vertical_offset = vertical_offset;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public int getHorizontalOffset(SquareCorners referenceCorner) {
            return referenceCorner.horizontal_offset == this.horizontal_offset ? 0 : this.horizontal_offset;
        }

        public int getVerticalOffset(SquareCorners referenceCorner) {
            return referenceCorner.vertical_offset == this.vertical_offset ? 0 : this.vertical_offset;
        }

        public boolean isTopCorner() {
            return this.vertical_offset == 1;
        }

        public SquareCorners getAdjacentCorner(boolean vertically) {
            return switch (this.ordinal()) {
                case 1 -> {
                    if (vertically) {
                        yield BOTTOM_RIGHT;
                    }
                    yield TOP_LEFT;
                }
                case 2 -> {
                    if (vertically) {
                        yield TOP_RIGHT;
                    }
                    yield BOTTOM_LEFT;
                }
                case 3 -> {
                    if (vertically) {
                        yield TOP_LEFT;
                    }
                    yield BOTTOM_RIGHT;
                }
                default -> vertically ? BOTTOM_LEFT : TOP_RIGHT;
            };
        }
    }

    public static enum VerticalLimitedConnection implements StringRepresentable
    {
        NONE("none", 0),
        BOTTOM("bottom", 1),
        TOP("top", 2);

        private final String name;
        private final int index;

        private VerticalLimitedConnection(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum WaterTrickleEnd implements StringRepresentable
    {
        STRAIGHT("straight"),
        FADE("fade"),
        SPLASH("splash");

        private final String name;

        private WaterTrickleEnd(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

