/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.dawnoftimebuilder.recipe.DryerRecipe;
import org.jetbrains.annotations.NotNull;

public class DryerRecipeSerializer
implements RecipeSerializer<DryerRecipe> {
    private final Factory<DryerRecipe> factory;
    private final MapCodec<DryerRecipe> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, DryerRecipe> streamCodec;

    public DryerRecipeSerializer(Factory<DryerRecipe> factory) {
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(o -> o.group), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(o -> o.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(o -> o.result), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(o -> Float.valueOf(o.experience)), (App)Codec.INT.optionalFieldOf("dryingTime", (Object)1200).forGetter(o -> o.dryingTime)).apply((Applicative)instance, factory::create));
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    @NotNull
    public DryerRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        String group = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        ItemStack itemStackResult = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        float experience = ((Float)ByteBufCodecs.FLOAT.decode((Object)buffer)).floatValue();
        int dryingTime = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer);
        return this.factory.create(group, ingredient, itemStackResult, experience, dryingTime);
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer, DryerRecipe recipe) {
        ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)recipe.group);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        ByteBufCodecs.FLOAT.encode((Object)buffer, (Object)Float.valueOf(recipe.experience));
        ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)recipe.dryingTime);
    }

    @NotNull
    public MapCodec<DryerRecipe> codec() {
        return this.codec;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, DryerRecipe> streamCodec() {
        return this.streamCodec;
    }

    @FunctionalInterface
    public static interface Factory<T extends DryerRecipe> {
        public T create(String var1, Ingredient var2, ItemStack var3, float var4, int var5);
    }
}

