/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.dawnoftimebuilder.registry.DoTBBlocksRegistry;
import org.dawnoftimebuilder.registry.DoTBRecipeSerializersRegistry;
import org.dawnoftimebuilder.registry.DoTBRecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class DryerRecipe
implements Recipe<SingleRecipeInput> {
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final float experience;
    protected final int dryingTime;

    public DryerRecipe(String group, Ingredient ingredient, ItemStack result, float experience, int dryingTime) {
        this.group = group;
        this.ingredient = ingredient;
        this.result = result;
        this.experience = experience;
        this.dryingTime = dryingTime;
    }

    public int getDryingTime() {
        return this.dryingTime;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public boolean matches(@NotNull SingleRecipeInput input, @NotNull Level level) {
        return this.ingredient.test(input.getItem(0)) && input.getItem(0).getCount() >= this.ingredient.getItems()[0].getCount();
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return DoTBRecipeSerializersRegistry.INSTANCE.DRYER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return DoTBRecipeTypesRegistry.INSTANCE.DRYING.get();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)DoTBBlocksRegistry.INSTANCE.BAMBOO_DRYING_TRAY.get());
    }

    public boolean isSpecial() {
        return true;
    }
}

