/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.mixin.impl.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.dawnoftimebuilder.DoTBCommon;
import org.dawnoftimebuilder.client.gui.creative.CreativeInventoryCategories;
import org.dawnoftimebuilder.client.gui.elements.buttons.CategoryButton;
import org.dawnoftimebuilder.client.gui.elements.buttons.GroupButton;
import org.dawnoftimebuilder.client.gui.elements.buttons.SocialsButton;
import org.dawnoftimebuilder.mixin.api.CreativeScreen;
import org.dawnoftimebuilder.registry.DoTBCreativeModeTabsRegistry;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(print=true)
@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeInventoryMixin
extends EffectRenderingInventoryScreen<CreativeModeInventoryScreen.ItemPickerMenu>
implements CreativeScreen {
    @Unique
    private List<CategoryButton> dOTBuilder$buttons;
    @Unique
    private Button dOTBuilder$btnScrollUp;
    @Unique
    private Button dOTBuilder$btnScrollDown;
    @Unique
    private Button dOTBuilder$discord;
    @Unique
    private Button dOTBuilder$curse;
    @Unique
    private Button dOTBuilder$patreon;
    @Unique
    private Button dOTBuilder$github;
    @Unique
    private static int dOTBuilder$selectedCategoryID = 0;
    @Unique
    private static int dOTBuilder$page = 0;
    @Unique
    private boolean dOTBuilder$tabDoTBSelected;
    @Unique
    private final int MAX_PAGE = (int)Math.floor((double)(CreativeInventoryCategories.values().length - 1) / 4.0);
    @Unique
    private static boolean dOTBuilder$hasSetItemsYet = false;

    @Shadow
    public abstract boolean mouseScrolled(double var1, double var3, double var5, double var7);

    protected CreativeInventoryMixin(CreativeModeInventoryScreen.ItemPickerMenu $$0, Inventory $$1, Component $$2) {
        super((AbstractContainerMenu)$$0, $$1, $$2);
    }

    @Override
    public int dOTBuilder$getPage() {
        return dOTBuilder$page;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void dawnoftimebuilder$init(CallbackInfo ci) {
        this.dOTBuilder$buttons = new ArrayList<CategoryButton>();
        this.dOTBuilder$btnScrollUp = new GroupButton(this.leftPos - 22, this.topPos - 22, (Component)Component.empty(), button -> {
            if (dOTBuilder$page > 0) {
                --dOTBuilder$page;
                this.dOTBuilder$updateCategoryButtons();
            }
        }, DoTBCommon.CREATIVE_ICONS, 0, 56);
        this.addRenderableWidget((GuiEventListener)this.dOTBuilder$btnScrollUp);
        this.dOTBuilder$btnScrollDown = new GroupButton(this.leftPos - 22, this.topPos + 120, (Component)Component.empty(), button -> {
            if (dOTBuilder$page < this.MAX_PAGE) {
                ++dOTBuilder$page;
                this.dOTBuilder$updateCategoryButtons();
            }
        }, DoTBCommon.CREATIVE_ICONS, 16, 56);
        this.addRenderableWidget((GuiEventListener)this.dOTBuilder$btnScrollDown);
        this.dOTBuilder$discord = new SocialsButton(this.leftPos + 200, this.topPos, "discord", button -> this.dOTBuilder$openLink("https://discord.gg/cteCdn9Hnf"));
        this.addRenderableWidget((GuiEventListener)this.dOTBuilder$discord);
        this.dOTBuilder$curse = new SocialsButton(this.leftPos + 200, this.topPos + 35, "curse", button -> this.dOTBuilder$openLink("https://www.curseforge.com/minecraft/mc-mods/dawn-of-time"));
        this.addRenderableWidget((GuiEventListener)this.dOTBuilder$curse);
        this.dOTBuilder$patreon = new SocialsButton(this.leftPos + 200, this.topPos + 70, "patreon", button -> this.dOTBuilder$openLink("https://www.patreon.com/dawnoftimemod"));
        this.addRenderableWidget((GuiEventListener)this.dOTBuilder$patreon);
        this.dOTBuilder$github = new SocialsButton(this.leftPos + 200, this.topPos + 105, "github", button -> this.dOTBuilder$openLink("https://github.com/PierreChag/dawnoftimebuilder"));
        this.addRenderableWidget((GuiEventListener)this.dOTBuilder$github);
        for (int i = 0; i < 4; ++i) {
            this.dOTBuilder$buttons.add(new CategoryButton(this.leftPos - 27, this.topPos + 30 * i, i, button -> {
                CategoryButton categoryButton = (CategoryButton)button;
                if (!categoryButton.isSelected()) {
                    this.dOTBuilder$buttons.get(dOTBuilder$selectedCategoryID % 4).setSelected(false);
                    categoryButton.setSelected(true);
                    dOTBuilder$selectedCategoryID = categoryButton.getCategoryID();
                    Screen screen1 = Minecraft.getInstance().screen;
                    if (screen1 instanceof CreativeModeInventoryScreen) {
                        this.dOTBuilder$updateItems((CreativeModeInventoryScreen)screen1);
                    }
                }
            }, this));
        }
        for (CategoryButton dOTBuilder$button : this.dOTBuilder$buttons) {
            this.addRenderableWidget((GuiEventListener)dOTBuilder$button);
        }
        this.dOTBuilder$updateCategoryButtons();
        if (this.dOTBuilder$tabDoTBSelected) {
            this.dOTBuilder$updateItems((CreativeModeInventoryScreen)this);
            this.dOTBuilder$toggleButtons(true);
            this.dOTBuilder$buttons.get(dOTBuilder$selectedCategoryID % 4).setSelected(true);
        } else {
            this.dOTBuilder$toggleButtons(false);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void dawnoftimebuilder$render(GuiGraphics $$0, int $$1, int $$2, float $$3, CallbackInfo ci) {
        if (!dOTBuilder$hasSetItemsYet && this.dOTBuilder$tabDoTBSelected) {
            this.dOTBuilder$updateItems((CreativeModeInventoryScreen)this);
            dOTBuilder$hasSetItemsYet = true;
        } else if (!this.dOTBuilder$tabDoTBSelected) {
            dOTBuilder$hasSetItemsYet = false;
        }
        this.dOTBuilder$toggleButtons(this.dOTBuilder$tabDoTBSelected);
    }

    @Unique
    private void dOTBuilder$toggleButtons(boolean val) {
        this.dOTBuilder$btnScrollUp.visible = val;
        this.dOTBuilder$btnScrollDown.visible = val;
        this.dOTBuilder$discord.visible = val;
        this.dOTBuilder$curse.visible = val;
        this.dOTBuilder$patreon.visible = val;
        this.dOTBuilder$github.visible = val;
        this.dOTBuilder$buttons.forEach(button -> {
            button.visible = val;
        });
    }

    @Inject(method={"selectTab"}, at={@At(value="HEAD")}, cancellable=false)
    public void dawnoftimebuilder$selectTab(CreativeModeTab $$0, CallbackInfo ci) {
        this.dOTBuilder$tabDoTBSelected = $$0 == DoTBCreativeModeTabsRegistry.INSTANCE.DOT_TAB.get();
    }

    @Inject(method={"mouseScrolled"}, at={@At(value="HEAD")}, cancellable=true)
    public void dawnoftimebuilder$mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, CallbackInfoReturnable<Boolean> cir) {
        int guiLeft = this.leftPos;
        int guiTop = this.topPos;
        int startX = guiLeft - 32;
        int startY = guiTop + 10;
        int endY = startY + 112 + 3;
        if (mouseX >= (double)startX && mouseX < (double)guiLeft && mouseY >= (double)startY && mouseY < (double)endY) {
            if (scrollY > 0.0) {
                this.dOTBuilder$scrollUp();
            } else {
                this.dOTBuilder$scrollDown();
            }
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private void dOTBuilder$updateCategoryButtons() {
        this.dOTBuilder$btnScrollUp.active = dOTBuilder$page > 0;
        this.dOTBuilder$btnScrollDown.active = dOTBuilder$page < this.MAX_PAGE;
        this.dOTBuilder$buttons.forEach(button -> {
            button.active = button.getCategoryID() < CreativeInventoryCategories.values().length;
        });
        this.dOTBuilder$buttons.get(dOTBuilder$selectedCategoryID % 4).setSelected(dOTBuilder$selectedCategoryID - dOTBuilder$page * 4 >= 0 && dOTBuilder$selectedCategoryID - dOTBuilder$page * 4 < 4);
    }

    @Unique
    private void dOTBuilder$updateItems(CreativeModeInventoryScreen screen) {
        this.mouseScrolled(0.0, 0.0, 3.4028234663852886E38, 1.4E-45f);
        CreativeModeInventoryScreen.ItemPickerMenu container = (CreativeModeInventoryScreen.ItemPickerMenu)screen.getMenu();
        container.items.clear();
        CreativeInventoryCategories.values()[dOTBuilder$selectedCategoryID].getItems().forEach(item -> container.items.add((Object)new ItemStack((ItemLike)item)));
        container.scrollTo(0.0f);
    }

    @Unique
    private void dOTBuilder$openLink(String link) {
        Util.getPlatform().openUri(link);
    }

    @Unique
    private void dOTBuilder$scrollUp() {
        if (dOTBuilder$page > 0) {
            --dOTBuilder$page;
            this.dOTBuilder$updateCategoryButtons();
        }
    }

    @Unique
    private void dOTBuilder$scrollDown() {
        if (dOTBuilder$page < this.MAX_PAGE) {
            ++dOTBuilder$page;
            this.dOTBuilder$updateCategoryButtons();
        }
    }
}

