/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.item.templates;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.dawnoftimebuilder.block.templates.FlowerPotBlockAA;
import org.dawnoftimebuilder.block.templates.SoilCropsBlock;
import org.dawnoftimebuilder.item.IHasFlowerPot;
import org.jetbrains.annotations.NotNull;

public class SoilSeedsItem
extends BlockItem
implements IHasFlowerPot {
    private FlowerPotBlockAA potBlock;

    public <T extends SoilCropsBlock> SoilSeedsItem(T crops, @Nullable FoodProperties food) {
        super(crops, food != null ? new Item.Properties().food(food) : new Item.Properties());
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        FlowerPotBlock pot;
        BlockPos pos;
        BlockState state;
        Block block;
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        if (!world.isClientSide() && this.getPotBlock() != null && (block = (state = world.getBlockState(pos = context.getClickedPos())).getBlock()) instanceof FlowerPotBlock && ((FlowerPotBlock)(pot = (FlowerPotBlock)block).defaultBlockState().getBlock()).getPotted() == Blocks.AIR) {
            Player player = context.getPlayer();
            if (player == null || !player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            world.setBlock(pos, this.getPotBlock().getRandomState(), 2);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (context.getClickedFace() != Direction.UP) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!this.getBlock().defaultBlockState().canSurvive((LevelReader)world, pos)) {
            return InteractionResult.FAIL;
        }
        if (!world.getBlockState(pos).canBeReplaced(context)) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockitemusecontext = this.updatePlacementContext(context);
        if (blockitemusecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState madeState = this.getPlacementState(blockitemusecontext);
        if (madeState == null) {
            return InteractionResult.FAIL;
        }
        if (!world.setBlock(pos, madeState, 11)) {
            return InteractionResult.FAIL;
        }
        Player playerentity = blockitemusecontext.getPlayer();
        ItemStack itemstack = blockitemusecontext.getItemInHand();
        BlockState newState = world.getBlockState(pos);
        Block block = newState.getBlock();
        if (block == madeState.getBlock()) {
            this.updateCustomBlockEntityTag(pos, world, playerentity, itemstack, newState);
            block.setPlacedBy(world, pos, newState, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)playerentity, pos, itemstack);
            }
        }
        SoundType soundtype = newState.getSoundType();
        world.playSound(playerentity, pos, this.getPlaceSound(newState), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        itemstack.shrink(1);
        return InteractionResult.SUCCESS;
    }

    @Override
    public FlowerPotBlockAA getPotBlock() {
        return this.potBlock;
    }

    @Override
    public void setPotBlock(FlowerPotBlockAA pot) {
        this.potBlock = pot;
    }
}

