/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.entity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.dawnoftimebuilder.block.templates.DoubleGrowingBushBlock;
import org.dawnoftimebuilder.platform.Services;
import org.dawnoftimebuilder.registry.DoTBBlocksRegistry;
import org.dawnoftimebuilder.registry.DoTBEntitiesRegistry;
import org.jetbrains.annotations.NotNull;

public class SilkmothEntity
extends AmbientCreature {
    private static final EntityDataAccessor<BlockPos> ROTATION_POS = SynchedEntityData.defineId(SilkmothEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Boolean> CLOCKWISE = SynchedEntityData.defineId(SilkmothEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.defineId(SilkmothEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public SilkmothEntity(Level worldIn) {
        super(DoTBEntitiesRegistry.INSTANCE.SILKMOTH_ENTITY.get(), worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0);
    }

    private float getNewRotationDistance() {
        return 0.5f + (float)Services.PLATFORM.getConfig().silkmothRotationMaxRange * this.random.nextFloat();
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData data) {
        this.getEntityData().set(ROTATION_POS, (Object)this.blockPosition());
        return super.finalizeSpawn(world, difficultyInstance, spawnReason, data);
    }

    protected void customServerAiStep() {
        double alpha;
        super.customServerAiStep();
        if (this.tickCount >= 24000 && !this.hasCustomName() && Services.PLATFORM.getConfig().silkmothMustDie) {
            this.hurt(this.damageSources().starve(), 20.0f);
        }
        if (this.random.nextInt(Services.PLATFORM.getConfig().silkmothRotationChange) == 0) {
            this.changeRotationPos();
        }
        BlockPos pos = (BlockPos)this.getEntityData().get(ROTATION_POS);
        double distance = ((Float)this.getEntityData().get(DISTANCE)).floatValue();
        double x = this.getX() - ((double)pos.getX() + 0.5);
        double z = this.getZ() - ((double)pos.getZ() + 0.5);
        if (z == 0.0) {
            alpha = x > 0.0 ? 0.0 : Math.PI;
        } else {
            alpha = Math.atan(z / x);
            if (x > 0.0) {
                alpha += Math.PI;
            }
        }
        double d = Math.sqrt(x * x + z * z);
        d = -distance * 2.0 / (d + distance) + 1.0;
        double d2 = (Boolean)this.getEntityData().get(CLOCKWISE) != false ? d - 1.0 : 1.0 - d;
        Vec3 motionVector = this.getDeltaMovement();
        this.setDeltaMovement(motionVector.x * 0.5 + Math.cos(alpha += d2 * Math.PI / 2.0) * 0.15, Math.sin((double)this.tickCount / 20.0) * 0.05, motionVector.z * 0.5 + Math.sin(alpha) * 0.15);
        float rot = (float)Mth.wrapDegrees((double)(180.0 * alpha / Math.PI - 90.0));
        this.setYHeadRot(rot);
        this.setYRot(rot);
    }

    private void changeRotationPos() {
        int horizontalRange = 5;
        int verticalRange = 2;
        int x = (int)this.level().getDayTime() % 23999;
        boolean isNight = x > 12000 && x < 23000;
        x = (int)Math.floor(this.getX()) - horizontalRange;
        int y = (int)Math.floor(this.getY()) - verticalRange;
        int z = (int)Math.floor(this.getZ()) - horizontalRange;
        ArrayList<BlockPos> listMulberry = new ArrayList<BlockPos>();
        ArrayList<BlockPos> listLight = new ArrayList<BlockPos>();
        for (int searchX = 0; searchX < 2 * horizontalRange + 1; ++searchX) {
            for (int searchZ = 0; searchZ < 2 * horizontalRange + 1; ++searchZ) {
                for (int searchY = 0; searchY < 2 * verticalRange + 1; ++searchY) {
                    BlockPos pos = new BlockPos(x + searchX, y + searchY, z + searchZ);
                    BlockState state = this.level().getBlockState(pos);
                    if (state.getBlock() == DoTBBlocksRegistry.INSTANCE.MULBERRY.get()) {
                        if (((DoubleGrowingBushBlock)state.getBlock()).isBottomCrop(state)) continue;
                        listMulberry.add(pos);
                        continue;
                    }
                    if (!isNight || state.getLightEmission() < 14) continue;
                    listLight.add(pos);
                }
            }
        }
        if (!listLight.isEmpty()) {
            this.getEntityData().set(ROTATION_POS, (Object)((BlockPos)listLight.get(this.random.nextInt(listLight.size()))));
        } else if (!listMulberry.isEmpty()) {
            this.getEntityData().set(ROTATION_POS, (Object)((BlockPos)listMulberry.get(this.random.nextInt(listMulberry.size()))));
        } else {
            this.getEntityData().set(ROTATION_POS, (Object)new BlockPos(x + this.random.nextInt(2 * horizontalRange + 1), y + this.random.nextInt(2 * verticalRange + 1), z + this.random.nextInt(2 * horizontalRange + 1)));
        }
        this.getEntityData().set(DISTANCE, (Object)Float.valueOf(this.getNewRotationDistance()));
    }

    public boolean causeFallDamage(float p_225503_1_, float p_225503_2_, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double p_184231_1_, boolean p_184231_3_, BlockState state, BlockPos pos) {
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entity) {
    }

    protected void pushEntities() {
    }

    protected float getSoundVolume() {
        return 0.2f;
    }

    public float getVoicePitch() {
        return super.getVoicePitch() * 0.9f;
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return !Services.PLATFORM.getConfig().silkmothMute && this.random.nextInt(4) == 0 ? SoundEvents.PARROT_FLY : null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.PARROT_FLY;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PARROT_FLY;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ROTATION_POS, (Object)new BlockPos((Vec3i)this.blockPosition()));
        builder.define(CLOCKWISE, (Object)this.random.nextBoolean());
        builder.define(DISTANCE, (Object)Float.valueOf(this.getNewRotationDistance()));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.getEntityData().set(ROTATION_POS, (Object)new BlockPos(compound.getInt("RotationX"), compound.getInt("RotationY"), compound.getInt("RotationZ")));
        this.getEntityData().set(CLOCKWISE, (Object)compound.getBoolean("RotationClockwise"));
        this.getEntityData().set(DISTANCE, (Object)Float.valueOf(compound.getFloat("RotationDistance")));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("RotationX", ((BlockPos)this.getEntityData().get(ROTATION_POS)).getX());
        compound.putInt("RotationY", ((BlockPos)this.getEntityData().get(ROTATION_POS)).getY());
        compound.putInt("RotationZ", ((BlockPos)this.getEntityData().get(ROTATION_POS)).getZ());
        compound.putBoolean("RotationClockwise", ((Boolean)this.getEntityData().get(CLOCKWISE)).booleanValue());
        compound.putFloat("RotationDistance", ((Float)this.getEntityData().get(DISTANCE)).floatValue());
    }
}

