/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.container;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.dawnoftimebuilder.block.IBlockSpecialDisplay;
import org.dawnoftimebuilder.block.templates.DisplayerBlock;
import org.dawnoftimebuilder.blockentity.DisplayerBlockEntity;
import org.dawnoftimebuilder.registry.DoTBMenuTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class DisplayerMenu
extends AbstractContainerMenu {
    private DisplayerBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;

    public <D extends DisplayerMenuData> DisplayerMenu(int windowId, Inventory playerInventory, D additionalData, RegistryFriendlyByteBuf buf) {
        this(windowId, playerInventory, playerInventory.player.level().getBlockEntity(additionalData != null ? additionalData.blockPos() : buf.readBlockPos()));
    }

    public DisplayerMenu(int windowId, Inventory playerInventory, BlockEntity blockEntity) {
        super(DoTBMenuTypesRegistry.INSTANCE.DISPLAYER.get(), windowId);
        DisplayerBlockEntity displayerBlockEntity;
        if (!(blockEntity instanceof DisplayerBlockEntity)) {
            throw new IllegalStateException(String.format("Incorrect block entity class (%s) passed into DisplayerMenu.", blockEntity.getClass().getCanonicalName()));
        }
        this.blockEntity = displayerBlockEntity = (DisplayerBlockEntity)blockEntity;
        this.levelAccess = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.blockEntity.itemHandler, j + i * 3, 19 + j * 18, 168 + i * 18));
            }
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, 9 + x + y * 9, 88 + x * 18, 157 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 88 + x * 18, 215));
        }
    }

    public boolean stillValid(Player playerIn) {
        if (this.blockEntity.getLevel() == null) {
            return false;
        }
        return DisplayerMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)playerIn, (Block)this.blockEntity.getBlockState().getBlock());
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.blockEntity.getLevel() != null && !this.blockEntity.getLevel().isClientSide()) {
            boolean lit = false;
            for (int index = 0; index < this.blockEntity.itemHandler.getContainerSize(); ++index) {
                Item item;
                ItemStack itemstack = this.blockEntity.itemHandler.getItem(index);
                if (!itemstack.isEmpty() && (item = itemstack.getItem()) instanceof BlockItem) {
                    Block block = ((BlockItem)item).getBlock();
                    if (block instanceof IBlockSpecialDisplay) {
                        lit = ((IBlockSpecialDisplay)block).emitsLight();
                    } else {
                        boolean bl = lit = block.defaultBlockState().getLightBlock((BlockGetter)this.blockEntity.getLevel(), this.blockEntity.getBlockPos()) > 0;
                    }
                }
                if (lit) break;
            }
            if ((Boolean)this.blockEntity.getBlockState().getValue((Property)DisplayerBlock.LIT) != lit) {
                this.blockEntity.getLevel().setBlock(this.blockEntity.getBlockPos(), (BlockState)this.blockEntity.getBlockState().setValue((Property)DisplayerBlock.LIT, (Comparable)Boolean.valueOf(lit)), 10);
            }
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackFromSlot = slot.getItem();
            itemStack = stackFromSlot.copy();
            if (index < 9 ? !this.moveItemStackTo(stackFromSlot, 9, this.slots.size(), true) : !this.moveItemStackTo(stackFromSlot, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (stackFromSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public record DisplayerMenuData(BlockPos blockPos) {
        public static final StreamCodec<RegistryFriendlyByteBuf, DisplayerMenuData> CODEC = new StreamCodec<RegistryFriendlyByteBuf, DisplayerMenuData>(){

            @NotNull
            public DisplayerMenuData decode(@NotNull RegistryFriendlyByteBuf buffer) {
                return new DisplayerMenuData(buffer.readBlockPos());
            }

            public void encode(@NotNull RegistryFriendlyByteBuf buffer, @NotNull DisplayerMenuData value) {
                buffer.writeBlockPos(value.blockPos);
            }
        };
    }
}

