/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.dawnoftimebuilder.entity.SilkmothEntity;

public class SilkmothModel<T extends SilkmothEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"dawnoftimebuilder", (String)"silkmoth"), "main");
    private final ModelPart root;
    private final ModelPart wingLeft;
    private final ModelPart wingRight;
    private final ModelPart head;

    public SilkmothModel(ModelPart root) {
        this.root = root.getChild("root");
        ModelPart body = this.root.getChild("body");
        this.wingLeft = body.getChild("wingLeft");
        this.wingRight = body.getChild("wingRight");
        this.head = body.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, -1.25f, -0.3f, 2.0f, 2.0f, 5.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.5f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.25f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition antennaLeft = head.addOrReplaceChild("antennaLeft", CubeListBuilder.create().texOffs(12, -7).addBox(-2.5f, -2.5f, -4.5f, 5.0f, 6.0f, 7.0f, new CubeDeformation(-2.5f)), PartPose.offsetAndRotation((float)-0.4f, (float)-0.5f, (float)-0.8f, (float)-0.5236f, (float)1.0472f, (float)0.0f));
        PartDefinition antennaRight = head.addOrReplaceChild("antennaRight", CubeListBuilder.create().texOffs(12, -7).addBox(-2.5f, -2.5f, -4.5f, 5.0f, 6.0f, 7.0f, new CubeDeformation(-2.5f)), PartPose.offsetAndRotation((float)0.4f, (float)-0.5f, (float)-0.8f, (float)-0.5236f, (float)-1.0472f, (float)0.0f));
        PartDefinition wingLeft = body.addOrReplaceChild("wingLeft", CubeListBuilder.create().texOffs(-12, 20).mirror().addBox(-3.5f, -3.5f, -3.5f, 14.0f, 7.0f, 12.0f, new CubeDeformation(-3.5f)).mirror(false), PartPose.offsetAndRotation((float)0.3f, (float)-0.8f, (float)0.5f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition wingRight = body.addOrReplaceChild("wingRight", CubeListBuilder.create().texOffs(-12, 20).addBox(-10.5f, -3.5f, -3.5f, 14.0f, 7.0f, 12.0f, new CubeDeformation(-3.5f)).mirror(false), PartPose.offsetAndRotation((float)-0.3f, (float)-0.8f, (float)0.5f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition legs = body.addOrReplaceChild("legs", CubeListBuilder.create().texOffs(9, 8).addBox(-2.5f, -2.28f, -1.55f, 5.0f, 5.0f, 5.0f, new CubeDeformation(-1.75f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float flap = 5.0f;
        float d = Math.abs(ageInTicks % flap / flap - 0.5f);
        this.wingLeft.zRot = (float)(Math.PI * (double)(0.2f - d));
        this.wingRight.zRot = (float)(Math.PI * (double)(-0.2f + d));
        this.head.xRot = headPitch * 0.018f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.5f, 0.0f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        poseStack.popPose();
    }
}

