/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.dawnoftimebuilder.DoTBCommon;
import org.dawnoftimebuilder.client.gui.creative.CreativeInventoryCategories;
import org.dawnoftimebuilder.mixin.api.CreativeScreen;
import org.jetbrains.annotations.NotNull;

public class CategoryButton
extends Button {
    private final CreativeScreen parent;
    private boolean selected = false;
    private static final ResourceLocation[] BUTTON_ICONS = CategoryButton.fillButtonIcons();
    private final int index;

    public CategoryButton(int x, int y, int index, Button.OnPress pressable, CreativeScreen parent) {
        super(x, y, 32, 28, (Component)Component.empty(), pressable, DEFAULT_NARRATION);
        this.index = index;
        this.parent = parent;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int getCategoryID() {
        return this.parent.dOTBuilder$getPage() * 4 + this.index;
    }

    public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.active && this.visible) {
            PoseStack ps = pGuiGraphics.pose();
            ps.pushPose();
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            pGuiGraphics.blit(DoTBCommon.CREATIVE_ICONS, this.getX() - 1, this.getY(), 0, this.selected ? 0 : 28, 31, 28);
            RenderSystem.disableBlend();
            ps.popPose();
            ps.pushPose();
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            pGuiGraphics.blit(BUTTON_ICONS[this.getCategoryID()], this.getX() + (this.selected ? 6 : 9), this.getY() + 6, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.disableBlend();
            ps.popPose();
        }
    }

    private static ResourceLocation[] fillButtonIcons() {
        int number = CreativeInventoryCategories.values().length;
        ResourceLocation[] table = new ResourceLocation[number];
        for (int i = 0; i < number; ++i) {
            table[i] = ResourceLocation.fromNamespaceAndPath((String)"dawnoftimebuilder", (String)("textures/item/logo_" + CreativeInventoryCategories.values()[i].getName() + ".png"));
        }
        return table;
    }
}

