/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blockentity;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.dawnoftimebuilder.platform.Services;
import org.dawnoftimebuilder.recipe.DryerRecipe;
import org.dawnoftimebuilder.registry.DoTBBlockEntitiesRegistry;
import org.dawnoftimebuilder.registry.DoTBRecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DryerBlockEntity
extends BlockEntity {
    public final SimpleContainer itemHandler = new SimpleContainer(2);
    private final int[] remainingTicks = new int[2];
    private boolean isInOperation;

    public DryerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(DoTBBlockEntitiesRegistry.INSTANCE.DRYER.get(), pPos, pBlockState);
    }

    public void tick() {
        if (this.getLevel() != null && this.isInOperation) {
            int finish = 0;
            boolean success = false;
            for (int slotIndex = 0; slotIndex < this.remainingTicks.length; ++slotIndex) {
                int n = slotIndex;
                this.remainingTicks[n] = this.remainingTicks[n] - 1;
                if (this.remainingTicks[slotIndex] > 0) continue;
                this.remainingTicks[slotIndex] = 0;
                DryerRecipe recipe = this.getDryerRecipe(new SingleRecipeInput(this.itemHandler.getItem(slotIndex)));
                if (recipe != null) {
                    this.itemHandler.setItem(slotIndex, recipe.getResultItem((HolderLookup.Provider)this.getLevel().registryAccess()).copy());
                    success = true;
                }
                ++finish;
            }
            if (success) {
                this.setChanged();
                BlockState state = this.level.getBlockState(this.worldPosition);
                this.getLevel().sendBlockUpdated(this.worldPosition, state, state, 3);
            }
            if (finish >= 2) {
                this.isInOperation = false;
            }
        }
    }

    public InteractionResult tryInsertItemStack(ItemStack itemStack, boolean simple, Level worldIn, BlockPos pos, Player player) {
        if (this.putItemStackInFreeSpace(itemStack, simple, player)) {
            return InteractionResult.SUCCESS;
        }
        if (simple) {
            if (this.itemIsDried(0)) {
                this.dropItemIndex(0, worldIn, pos);
                this.putItemStackInIndex(0, itemStack, player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        int index = this.dropOneDriedItem(worldIn, pos);
        if (index < 0) {
            return InteractionResult.PASS;
        }
        this.putItemStackInIndex(index, itemStack, player);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult dropOneItem(Level worldIn, BlockPos pos) {
        if (this.dropOneDriedItem(worldIn, pos) > -1) {
            return InteractionResult.SUCCESS;
        }
        if (!this.itemHandler.getItem(0).isEmpty()) {
            this.dropItemIndex(0, worldIn, pos);
            return InteractionResult.SUCCESS;
        }
        if (!this.itemHandler.getItem(1).isEmpty()) {
            this.dropItemIndex(1, worldIn, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int dropOneDriedItem(Level worldIn, BlockPos pos) {
        if (this.itemIsDried(0)) {
            this.dropItemIndex(0, worldIn, pos);
            return 0;
        }
        if (this.itemIsDried(1)) {
            this.dropItemIndex(1, worldIn, pos);
            return 1;
        }
        return -1;
    }

    private boolean itemIsDried(int index) {
        if (this.itemHandler.getItem(index).isEmpty()) {
            return false;
        }
        return this.remainingTicks[index] <= 0;
    }

    private boolean putItemStackInFreeSpace(ItemStack itemStack, boolean simple, Player player) {
        if (this.itemHandler.getItem(0).isEmpty() && this.putItemStackInIndex(0, itemStack, player)) {
            this.isInOperation = true;
            return true;
        }
        if (!simple && this.itemHandler.getItem(1).isEmpty() && this.putItemStackInIndex(1, itemStack, player)) {
            this.isInOperation = true;
            return true;
        }
        return false;
    }

    @Nullable
    private DryerRecipe getDryerRecipe(SingleRecipeInput ingredientInventory) {
        if (this.getLevel() != null && !this.getLevel().isClientSide) {
            RecipeHolder recipeHolder = this.getLevel().getRecipeManager().getRecipeFor(DoTBRecipeTypesRegistry.INSTANCE.DRYING.get(), (RecipeInput)ingredientInventory, this.getLevel()).orElse(null);
            return recipeHolder != null ? (DryerRecipe)recipeHolder.value() : null;
        }
        return null;
    }

    private boolean putItemStackInIndex(int index, ItemStack itemStack, Player player) {
        SingleRecipeInput invInHand;
        DryerRecipe recipe;
        if (this.getLevel() != null && (recipe = this.getDryerRecipe(invInHand = new SingleRecipeInput(itemStack))) != null && recipe.matches(invInHand, this.getLevel())) {
            float timeVariation;
            this.itemHandler.setItem(index, ((Ingredient)recipe.getIngredients().get(0)).getItems()[0].copy());
            if (!player.isCreative()) {
                itemStack.shrink(((Ingredient)recipe.getIngredients().get(0)).getItems()[0].getCount());
            }
            int range = (timeVariation = new Random().nextFloat() * 2.0f - 1.0f) >= 0.0f ? Services.PLATFORM.getConfig().dryingTimeVariation : 10000 / (100 + Services.PLATFORM.getConfig().dryingTimeVariation);
            this.remainingTicks[index] = (int)((float)recipe.getDryingTime() * (100.0f + timeVariation * (float)range) / 100.0f);
            this.setChanged();
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.getLevel().sendBlockUpdated(this.worldPosition, state, state, 3);
            return true;
        }
        return false;
    }

    private void dropItemIndex(int index, Level worldIn, BlockPos pos) {
        Block.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)this.itemHandler.removeItem(index, 64));
        this.remainingTicks[index] = 0;
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(pos);
            this.setChanged();
            this.getLevel().sendBlockUpdated(this.worldPosition, state, state, 2);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        if (!this.itemHandler.getItem(0).isEmpty()) {
            tag.put("slot_0", this.itemHandler.getItem(0).save(registries));
        }
        if (!this.itemHandler.getItem(1).isEmpty()) {
            tag.put("slot_1", this.itemHandler.getItem(1).save(registries));
        }
        tag.putBoolean("isInOperation", this.isInOperation);
        return tag;
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        if (!this.itemHandler.getItem(0).isEmpty()) {
            tag.put("slot_0", this.itemHandler.getItem(0).save(registries));
        }
        if (!this.itemHandler.getItem(1).isEmpty()) {
            tag.put("slot_1", this.itemHandler.getItem(1).save(registries));
        }
        for (int index = 0; index < 2; ++index) {
            tag.putInt("remainingTime" + index, this.remainingTicks[index]);
        }
        tag.putBoolean("isInOperation", this.isInOperation);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        this.itemHandler.clearContent();
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("slot_0"));
        if (!stack.isEmpty()) {
            this.itemHandler.setItem(0, stack);
        }
        if (!(stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("slot_1"))).isEmpty()) {
            this.itemHandler.setItem(1, stack);
        }
        for (int index = 0; index < 2; ++index) {
            this.remainingTicks[index] = tag.getInt("remainingTime" + index);
        }
        this.isInOperation = tag.getBoolean("isInOperation");
        super.loadAdditional(tag, registries);
    }
}

