/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class WildPlantBlock
extends BlockAA {
    public WildPlantBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties.pushReaction(PushReaction.DESTROY), shapes);
    }

    public WildPlantBlock(BlockBehaviour.Properties properties) {
        this(properties, VoxelShapes.WILD_PLANT_SHAPES);
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Vec3 vector = state.getOffset(worldIn, pos);
        return super.getShape(state, worldIn, pos, context).move(vector.x, vector.y, vector.z);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.canSurvive(this.defaultBlockState(), (LevelReader)context.getLevel(), context.getClickedPos()) ? super.getStateForPlacement(context) : null;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState blockDown = worldIn.getBlockState(pos.below());
        return blockDown.getBlock() == Blocks.GRASS_BLOCK || blockDown.is(BlockTags.DIRT) || blockDown.getBlock() == Blocks.FARMLAND;
    }
}

