/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.block.templates.PoolBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;

public class WaterJetBlock
extends BlockAA {
    public WaterJetBlock(BlockBehaviour.Properties propertiesIn) {
        super(propertiesIn);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(false))).setValue(BlockStatePropertiesAA.NORTH_STATE, (Comparable)((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE))).setValue(BlockStatePropertiesAA.EAST_STATE, (Comparable)((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE))).setValue(BlockStatePropertiesAA.SOUTH_STATE, (Comparable)((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE))).setValue(BlockStatePropertiesAA.WEST_STATE, (Comparable)((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE))).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.UP, BlockStateProperties.DOWN, BlockStatePropertiesAA.NORTH_STATE, BlockStatePropertiesAA.EAST_STATE, BlockStatePropertiesAA.SOUTH_STATE, BlockStatePropertiesAA.WEST_STATE, BlockStateProperties.POWERED, BlockStatePropertiesAA.ACTIVATED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.getBlock() != this) {
            state = super.getStateForPlacement(context);
        }
        if (state == null) {
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true));
        }
        BlockStatePropertiesAA.VerticalLimitedConnection clickedFace = context.getClickLocation().y - (double)context.getClickedPos().getY() <= 0.5 ? BlockStatePropertiesAA.VerticalLimitedConnection.BOTTOM : BlockStatePropertiesAA.VerticalLimitedConnection.TOP;
        return switch (context.getClickedFace()) {
            default -> (BlockState)state.setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true));
            case Direction.DOWN -> (BlockState)state.setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(true));
            case Direction.SOUTH -> (BlockState)state.setValue(BlockStatePropertiesAA.NORTH_STATE, (Comparable)((Object)clickedFace));
            case Direction.WEST -> (BlockState)state.setValue(BlockStatePropertiesAA.EAST_STATE, (Comparable)((Object)clickedFace));
            case Direction.NORTH -> (BlockState)state.setValue(BlockStatePropertiesAA.SOUTH_STATE, (Comparable)((Object)clickedFace));
            case Direction.EAST -> (BlockState)state.setValue(BlockStatePropertiesAA.WEST_STATE, (Comparable)((Object)clickedFace));
        };
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        if (useContext.getPlayer() != null && useContext.getPlayer().isCrouching()) {
            return false;
        }
        if (itemstack.getItem() == this.asItem()) {
            Direction newDirection = useContext.getClickedFace();
            return switch (newDirection) {
                default -> {
                    if (!((Boolean)state.getValue((Property)BlockStateProperties.UP)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.DOWN -> {
                    if (!((Boolean)state.getValue((Property)BlockStateProperties.DOWN)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.SOUTH -> BlockStatePropertiesAA.VerticalLimitedConnection.NONE.equals(state.getValue(BlockStatePropertiesAA.NORTH_STATE));
                case Direction.WEST -> BlockStatePropertiesAA.VerticalLimitedConnection.NONE.equals(state.getValue(BlockStatePropertiesAA.EAST_STATE));
                case Direction.NORTH -> BlockStatePropertiesAA.VerticalLimitedConnection.NONE.equals(state.getValue(BlockStatePropertiesAA.SOUTH_STATE));
                case Direction.EAST -> BlockStatePropertiesAA.VerticalLimitedConnection.NONE.equals(state.getValue(BlockStatePropertiesAA.WEST_STATE));
            };
        }
        return false;
    }

    public InteractionResult useWithoutItem(BlockState blockStateIn, Level worldIn, BlockPos blockPosIn, Player playerEntityIn, BlockHitResult blockRaytraceResultIn) {
        ItemStack mainHandItemStack = playerEntityIn.getMainHandItem();
        if (!mainHandItemStack.isEmpty() && mainHandItemStack.getItem() == this.asItem()) {
            return InteractionResult.PASS;
        }
        blockStateIn = (BlockState)blockStateIn.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf((Boolean)blockStateIn.getValue((Property)BlockStatePropertiesAA.ACTIVATED) == false));
        worldIn.setBlock(blockPosIn, blockStateIn, 10);
        return InteractionResult.SUCCESS;
    }

    public BlockState updateShape(BlockState stateIn, Direction directionIn, BlockState facingStateIn, LevelAccessor worldIn, BlockPos currentPosIn, BlockPos facingPosIn) {
        switch (directionIn) {
            case NORTH: {
                if (((BlockStatePropertiesAA.VerticalLimitedConnection)((Object)stateIn.getValue(BlockStatePropertiesAA.NORTH_STATE))).equals((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE) || !(facingStateIn.getBlock() instanceof PoolBlock)) break;
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                stateIn = (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= ((PoolBlock)facingStateIn.getBlock()).faucetLevel));
                break;
            }
            case SOUTH: {
                if (((BlockStatePropertiesAA.VerticalLimitedConnection)((Object)stateIn.getValue(BlockStatePropertiesAA.SOUTH_STATE))).equals((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE) || !(facingStateIn.getBlock() instanceof PoolBlock)) break;
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                stateIn = (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= ((PoolBlock)facingStateIn.getBlock()).faucetLevel));
                break;
            }
            case EAST: {
                if (((BlockStatePropertiesAA.VerticalLimitedConnection)((Object)stateIn.getValue(BlockStatePropertiesAA.EAST_STATE))).equals((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE) || !(facingStateIn.getBlock() instanceof PoolBlock)) break;
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                stateIn = (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= ((PoolBlock)facingStateIn.getBlock()).faucetLevel));
                break;
            }
            case WEST: {
                if (((BlockStatePropertiesAA.VerticalLimitedConnection)((Object)stateIn.getValue(BlockStatePropertiesAA.WEST_STATE))).equals((Object)BlockStatePropertiesAA.VerticalLimitedConnection.NONE) || !(facingStateIn.getBlock() instanceof PoolBlock)) break;
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                stateIn = (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= ((PoolBlock)facingStateIn.getBlock()).faucetLevel));
                break;
            }
            case UP: {
                if (!((Boolean)stateIn.getValue((Property)BlockStateProperties.UP)).booleanValue() || !(facingStateIn.getBlock() instanceof PoolBlock)) break;
                System.out.println("A !");
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                stateIn = (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level > 0));
                break;
            }
            case DOWN: {
                if (!(facingStateIn.getBlock() instanceof PoolBlock)) break;
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                stateIn = (BlockState)stateIn.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= ((PoolBlock)facingStateIn.getBlock()).maxLevel - 1));
            }
        }
        return stateIn;
    }
}

