/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftimebuilder.block.IBlockGeneration;
import org.dawnoftimebuilder.platform.Services;
import org.dawnoftimebuilder.util.Utils;

public class SoilCropsBlock
extends CropBlock
implements IBlockGeneration {
    private final PlantType plantType;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;

    public SoilCropsBlock(PlantType type) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SUNFLOWER).offsetType(BlockBehaviour.OffsetType.NONE).randomTicks().sound(SoundType.CROP));
        this.plantType = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PERSISTENT});
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        float f;
        int age;
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            return;
        }
        if (!worldIn.isLoaded(pos)) {
            return;
        }
        if (worldIn.getRawBrightness(pos, 0) >= 9 && (age = this.getAge(state)) < this.getMaxAge() && random.nextInt((int)(25.0f / (f = Services.PLATFORM.getGrowthSpeed((Block)this, (BlockGetter)worldIn, pos))) + 1) == 0) {
            this.setPlantWithAge(state, (LevelAccessor)worldIn, pos, age + 1);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.mayGenerateOn((BlockGetter)world, pos.below(), this.getPlantType()) && super.canSurvive(state, world, pos);
    }

    private PlantType getPlantType() {
        return this.plantType;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter world, BlockPos pos) {
        return this.mayGenerateOn(world, pos, this.getPlantType());
    }

    public boolean mayGenerateOn(BlockGetter worldIn, BlockPos pos, PlantType plantType) {
        BlockState stateOn = worldIn.getBlockState(pos);
        Block blockOn = stateOn.getBlock();
        if (plantType.equals((Object)PlantType.DESERT)) {
            return stateOn.is(Blocks.SAND) || stateOn.is(Blocks.TERRACOTTA) || blockOn instanceof GlazedTerracottaBlock;
        }
        if (plantType.equals((Object)PlantType.NETHER)) {
            return stateOn.is(Blocks.SOUL_SAND);
        }
        if (plantType.equals((Object)PlantType.CROP)) {
            return stateOn.is(Blocks.FARMLAND);
        }
        if (plantType.equals((Object)PlantType.CAVE)) {
            return stateOn.isFaceSturdy(worldIn, pos, Direction.UP);
        }
        if (plantType.equals((Object)PlantType.PLAINS)) {
            return stateOn.is(Blocks.GRASS_BLOCK) || stateOn.is(Blocks.DIRT) || stateOn.is(Blocks.FARMLAND);
        }
        if (plantType.equals((Object)PlantType.WATER)) {
            return worldIn.getFluidState(pos.above()).getType() == Fluids.WATER && (stateOn.is(Blocks.CLAY) || stateOn.is(Blocks.DIRT) || stateOn.is(Blocks.FARMLAND) || stateOn.is(Blocks.GRAVEL));
        }
        if (plantType.equals((Object)PlantType.BEACH)) {
            boolean isBeach;
            boolean bl = isBeach = stateOn.is(Blocks.GRASS_BLOCK) || stateOn.is(Blocks.DIRT) || stateOn.is(Blocks.SAND) || stateOn.is(Blocks.RED_SAND);
            if (isBeach) {
                boolean hasWater = false;
                for (Direction face : Direction.Plane.HORIZONTAL) {
                    BlockState blockState = worldIn.getBlockState(pos.relative(face));
                    FluidState fluidState = worldIn.getFluidState(pos.relative(face));
                    hasWater = blockState.is(Blocks.FROSTED_ICE);
                    if (!(hasWater |= fluidState.is(FluidTags.WATER))) continue;
                    break;
                }
                return hasWater;
            }
        }
        return false;
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            if (player.isCreative()) {
                int age = this.getAge(state);
                if (player.isCrouching()) {
                    if (age > 0) {
                        this.setPlantWithAge(state, (LevelAccessor)worldIn, pos, age - 1);
                        return InteractionResult.SUCCESS;
                    }
                } else if (age < this.getMaxAge()) {
                    this.setPlantWithAge(state, (LevelAccessor)worldIn, pos, age + 1);
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (Utils.useLighter(worldIn, pos, player, player.getUsedItemHand())) {
            Random rand = new Random();
            for (int i = 0; i < 5; ++i) {
                worldIn.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + rand.nextDouble(), (double)pos.getY() + 0.5 + rand.nextDouble() / 2.0, (double)pos.getZ() + rand.nextDouble(), 0.0, 0.07, 0.0);
            }
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 10);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, worldIn, pos, player, hit);
    }

    public void setPlantWithAge(BlockState currentState, LevelAccessor worldIn, BlockPos pos, int newAge) {
        worldIn.setBlock(pos, (BlockState)currentState.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(newAge)), 10);
    }

    @Nonnull
    protected ItemLike getBaseSeedId() {
        return this.asItem();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Utils.addTooltip(tooltip, "crop");
    }

    @Override
    public boolean generateOnPos(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random) {
        BlockState groundState = world.getBlockState(pos.below());
        if (!groundState.is(BlockTags.DIRT)) {
            return false;
        }
        this.setPlantWithAge(state, (LevelAccessor)world, pos, random.nextInt(this.getMaxAge() + 1));
        return true;
    }

    public static enum PlantType {
        DESERT,
        NETHER,
        CROP,
        CAVE,
        PLAINS,
        WATER,
        BEACH;

    }
}

