/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.PoolBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class SmallPoolBlock
extends PoolBlock {
    public SmallPoolBlock(BlockBehaviour.Properties propertiesIn) {
        super(propertiesIn, 6, 4, VoxelShapes.SMALL_POOL_SHAPES);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.BOTTOM});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        if (((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue()) {
            index += 8;
        }
        if (((Boolean)state.getValue((Property)BlockStatePropertiesAA.HAS_PILLAR)).booleanValue()) {
            index += 16;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.BOTTOM)).booleanValue()) {
            index += 32;
        }
        return index;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int index = 0;
        if (((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue()) {
            index += 8;
        }
        if (((Boolean)state.getValue((Property)BlockStatePropertiesAA.HAS_PILLAR)).booleanValue()) {
            index += 16;
        }
        return VoxelShapes.SMALL_POOL_COLLISION_SHAPES[index];
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null && !SmallPoolBlock.canSupportCenter((LevelReader)context.getLevel(), (BlockPos)context.getClickedPos().below(), (Direction)Direction.UP)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.BOTTOM, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction directionIn, BlockState facingStateIn, LevelAccessor worldIn, BlockPos currentPosIn, BlockPos facingPosIn) {
        stateIn = super.updateShape(stateIn, directionIn, facingStateIn, worldIn, currentPosIn, facingPosIn);
        if (directionIn == Direction.DOWN) {
            stateIn = (BlockState)stateIn.setValue((Property)BlockStateProperties.BOTTOM, (Comparable)Boolean.valueOf(SmallPoolBlock.canSupportCenter((LevelReader)worldIn, (BlockPos)facingPosIn, (Direction)Direction.UP)));
        }
        return stateIn;
    }
}

