/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.Utils;
import org.jetbrains.annotations.NotNull;

public class SidedWindowBlock
extends BlockAA {
    public static final EnumProperty<BlockStatePropertiesAA.SidedWindow> SIDED_WINDOW = BlockStatePropertiesAA.SIDED_WINDOW;
    private static final BooleanProperty UP = BlockStateProperties.UP;
    private static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    private static final VoxelShape NORTH_VS = Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)6.0);
    private static final VoxelShape EAST_VS = Block.box((double)10.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_VS = Block.box((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape WEST_VS = Block.box((double)2.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0);
    private static final VoxelShape X_VS = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape Z_VS = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public SidedWindowBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(SIDED_WINDOW, (Comparable)((Object)BlockStatePropertiesAA.SidedWindow.AXIS_X))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SIDED_WINDOW, UP, ATTACHED});
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((BlockStatePropertiesAA.SidedWindow)((Object)state.getValue(SIDED_WINDOW))) {
            default -> NORTH_VS;
            case BlockStatePropertiesAA.SidedWindow.EAST -> EAST_VS;
            case BlockStatePropertiesAA.SidedWindow.SOUTH -> SOUTH_VS;
            case BlockStatePropertiesAA.SidedWindow.WEST -> WEST_VS;
            case BlockStatePropertiesAA.SidedWindow.AXIS_X -> X_VS;
            case BlockStatePropertiesAA.SidedWindow.AXIS_Z -> Z_VS;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = (BlockState)this.defaultBlockState().setValue(SIDED_WINDOW, (Comparable)((Object)BlockStatePropertiesAA.SidedWindow.getSide(context.getHorizontalDirection(), context.getPlayer() != null && context.getPlayer().isCrouching())));
        return (BlockState)((BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(this.canConnectVertical(state, worldIn, pos)))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(this.canConnectHorizontal(state, worldIn, pos)));
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos, isMoving);
        boolean changeTOP = this.canConnectVertical(state, worldIn, pos);
        boolean changeSIDE = this.canConnectHorizontal(state, worldIn, pos);
        BlockState newState = state;
        if (changeTOP != (Boolean)state.getValue((Property)UP)) {
            newState = (BlockState)newState.setValue((Property)UP, (Comparable)Boolean.valueOf(changeTOP));
        }
        if (changeSIDE != (Boolean)state.getValue((Property)ATTACHED)) {
            newState = (BlockState)newState.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(changeSIDE));
        }
        if (changeTOP != (Boolean)state.getValue((Property)UP) || changeSIDE != (Boolean)state.getValue((Property)ATTACHED)) {
            worldIn.setBlock(pos, newState, 10);
        }
    }

    private boolean canConnectVertical(BlockState state, Level worldIn, BlockPos pos) {
        if (this.isSameWindowAndSide(state, worldIn, pos.below())) {
            return !this.isSameWindowAndSide(state, worldIn, pos.above());
        }
        return false;
    }

    private boolean canConnectHorizontal(BlockState state, Level worldIn, BlockPos pos) {
        return this.isSameWindowAndSide(state, worldIn, pos.relative(((BlockStatePropertiesAA.SidedWindow)((Object)state.getValue(SIDED_WINDOW))).getOffset()));
    }

    private boolean isSameWindowAndSide(BlockState state, Level worldIn, BlockPos pos) {
        BlockState otherState = worldIn.getBlockState(pos);
        if (otherState.getBlock() == this) {
            return otherState.getValue(SIDED_WINDOW) == state.getValue(SIDED_WINDOW);
        }
        return false;
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rot) {
        return switch (rot) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> state;
            case Rotation.CLOCKWISE_90 -> (BlockState)state.setValue(SIDED_WINDOW, (Comparable)((Object)((BlockStatePropertiesAA.SidedWindow)((Object)state.getValue(SIDED_WINDOW))).rotate(true)));
            case Rotation.CLOCKWISE_180 -> (BlockState)state.setValue(SIDED_WINDOW, (Comparable)((Object)((BlockStatePropertiesAA.SidedWindow)((Object)state.getValue(SIDED_WINDOW))).rotate(false)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)state.setValue(SIDED_WINDOW, (Comparable)((Object)((BlockStatePropertiesAA.SidedWindow)((Object)state.getValue(SIDED_WINDOW))).rotate(true).rotate(true)));
        };
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return this.rotate(state, Rotation.CLOCKWISE_180);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Utils.addTooltip(tooltip, "sided_window");
    }
}

