/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import org.dawnoftimebuilder.block.templates.SmallShutterBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.jetbrains.annotations.NotNull;

public class ShutterBlock
extends SmallShutterBlock {
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;

    public ShutterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        Direction direction = context.getHorizontalDirection();
        BlockPos pos = context.getClickedPos();
        if (!world.getBlockState(pos.above()).canBeReplaced(context)) {
            return null;
        }
        int x = direction.getStepX();
        int z = direction.getStepZ();
        double onX = context.getClickLocation().x - (double)pos.getX();
        double onZ = context.getClickLocation().z - (double)pos.getZ();
        boolean hingeLeft = !(x < 0 && !(onZ >= 0.5) || x > 0 && !(onZ <= 0.5) || z < 0 && !(onX <= 0.5) || z > 0 && !(onX >= 0.5));
        return (BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue(SmallShutterBlock.HINGE, (Comparable)(hingeLeft ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT))).setValue((Property)SmallShutterBlock.FACING, (Comparable)direction)).setValue((Property)SmallShutterBlock.POWERED, (Comparable)Boolean.valueOf(world.hasNeighborSignal(pos)))).setValue(HALF, (Comparable)Half.BOTTOM);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.getValue(HALF) != Half.TOP) {
            return true;
        }
        BlockState bottomState = worldIn.getBlockState(pos.below());
        if (bottomState.getBlock() == this) {
            return bottomState.getValue(HALF) == Half.BOTTOM && bottomState.getValue((Property)SmallShutterBlock.FACING) == state.getValue((Property)SmallShutterBlock.FACING) && bottomState.getValue(SmallShutterBlock.HINGE) == state.getValue(SmallShutterBlock.HINGE);
        }
        return false;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack itemStack) {
        worldIn.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)Half.TOP), 10);
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction halfDirection;
        Direction direction = halfDirection = stateIn.getValue(HALF) == Half.TOP ? Direction.DOWN : Direction.UP;
        if (facing == halfDirection) {
            if (facingState.getBlock() != this || facingState.getValue(HALF) == stateIn.getValue(HALF) || facingState.getValue((Property)SmallShutterBlock.FACING) != stateIn.getValue((Property)SmallShutterBlock.FACING) || facingState.getValue(SmallShutterBlock.HINGE) != stateIn.getValue(SmallShutterBlock.HINGE)) {
                return Blocks.AIR.defaultBlockState();
            }
            stateIn = (BlockState)stateIn.setValue(SmallShutterBlock.OPEN_POSITION, (Comparable)((Object)((BlockStatePropertiesAA.OpenPosition)((Object)facingState.getValue(SmallShutterBlock.OPEN_POSITION)))));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    protected BlockStatePropertiesAA.OpenPosition getOpenState(BlockState stateIn, LevelAccessor worldIn, BlockPos pos) {
        BlockPos secondPos = pos.relative(stateIn.getValue(HALF) == Half.TOP ? Direction.DOWN : Direction.UP);
        if (!worldIn.getBlockState(secondPos).getCollisionShape((BlockGetter)worldIn, pos).isEmpty() || !worldIn.getBlockState(pos).getCollisionShape((BlockGetter)worldIn, pos).isEmpty()) {
            return BlockStatePropertiesAA.OpenPosition.HALF;
        }
        return BlockStatePropertiesAA.OpenPosition.FULL;
    }

    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos adjacentPos;
        BlockState adjacentState;
        if (!level.isClientSide() && player.isCreative() && state.getValue(HALF) == Half.TOP && (adjacentState = level.getBlockState(adjacentPos = pos.below())).is((Block)this) && adjacentState.getValue(HALF) == Half.BOTTOM) {
            level.setBlock(adjacentPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, adjacentPos, Block.getId((BlockState)state));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }
}

