/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftimebuilder.block.templates.WaterloggedBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.Utils;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class PortcullisBlock
extends WaterloggedBlock {
    private static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    private static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    private static final EnumProperty<BlockStatePropertiesAA.VerticalConnection> VERTICAL_CONNECTION = BlockStatePropertiesAA.VERTICAL_CONNECTION;

    public PortcullisBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.PORTCULLIS_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).setValue(VERTICAL_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.VerticalConnection.NONE)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPEN, POWERED, HORIZONTAL_AXIS, VERTICAL_CONNECTION});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && state.getValue(VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.NONE && state.getValue(VERTICAL_CONNECTION) != BlockStatePropertiesAA.VerticalConnection.UNDER) {
            return 0;
        }
        return state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? 1 : 2;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        state = (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(context.getHorizontalDirection().getAxis() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        return this.getShape(state, (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return this.getShape(stateIn, worldIn, currentPos);
    }

    private BlockState getShape(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
        if (this.hasSameAxis(worldIn.getBlockState(pos.above()), axis)) {
            return (BlockState)state.setValue(VERTICAL_CONNECTION, (Comparable)((Object)(this.hasSameAxis(worldIn.getBlockState(pos.below()), axis) ? BlockStatePropertiesAA.VerticalConnection.BOTH : BlockStatePropertiesAA.VerticalConnection.ABOVE)));
        }
        return (BlockState)state.setValue(VERTICAL_CONNECTION, (Comparable)((Object)(this.hasSameAxis(worldIn.getBlockState(pos.below()), axis) ? BlockStatePropertiesAA.VerticalConnection.UNDER : BlockStatePropertiesAA.VerticalConnection.NONE)));
    }

    private boolean hasSameAxis(BlockState state, Direction.Axis axis) {
        if (state.getBlock() instanceof PortcullisBlock) {
            return state.getValue(HORIZONTAL_AXIS) == axis;
        }
        return false;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Direction.Axis axis;
        if (state.getValue(VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.UNDER) {
            Direction.Axis axis2 = (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
            boolean isNowPowered = worldIn.hasNeighborSignal(pos);
            if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                if (this.isInSamePlane(pos, fromPos, axis2) && isNowPowered) {
                    this.setOpenState(worldIn, pos, axis2, true);
                }
            } else if (isNowPowered) {
                this.setOpenState(worldIn, pos, axis2, true);
                state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true));
            }
            if (!isNowPowered && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
                worldIn.setBlock(pos, state, 2);
                if (!this.hasAnotherPowerSource(worldIn, pos, axis2)) {
                    this.setOpenState(worldIn, pos, axis2, false);
                }
            }
            if (isNowPowered != (Boolean)state.getValue((Property)POWERED)) {
                state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isNowPowered));
                worldIn.setBlock(pos, state, 2);
            }
        } else if (state.getValue(VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.NONE) {
            if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 2);
            }
        } else if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && this.isInSamePlane(pos, fromPos, axis = (Direction.Axis)state.getValue(HORIZONTAL_AXIS))) {
            pos = this.getTopPortcullisPos(worldIn, pos, axis);
            worldIn.getBlockState(pos).handleNeighborChanged(worldIn, pos, blockIn, fromPos, isMoving);
        }
    }

    private boolean isInSamePlane(BlockPos pos, BlockPos fromPos, Direction.Axis axis) {
        return axis == Direction.Axis.X ? fromPos.getZ() == pos.getZ() : fromPos.getX() == pos.getX();
    }

    private BlockPos getTopPortcullisPos(Level worldIn, BlockPos pos, Direction.Axis axis) {
        boolean isStillPortcullis = true;
        while (isStillPortcullis) {
            BlockState state = worldIn.getBlockState(pos);
            if (state.getBlock() instanceof PortcullisBlock) {
                if (!this.hasSameAxis(state, axis)) {
                    isStillPortcullis = false;
                }
            } else {
                isStillPortcullis = false;
            }
            pos = pos.above();
        }
        return pos.below();
    }

    private boolean hasAnotherPowerSource(Level worldIn, BlockPos pos, Direction.Axis axis) {
        boolean isAxisX = axis == Direction.Axis.X;
        Direction direction = isAxisX ? Direction.WEST : Direction.NORTH;
        int widthLeft = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? Direction.EAST : Direction.SOUTH);
        int widthRight = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? Direction.WEST : Direction.NORTH);
        pos = pos.relative(direction, -widthLeft);
        for (int i = 0; i <= widthLeft + widthRight; ++i) {
            BlockState state = worldIn.getBlockState(pos.relative(direction, i));
            if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void setOpenState(Level worldIn, BlockPos pos, Direction.Axis axis, boolean openState) {
        BlockState state;
        boolean isAxisX = axis == Direction.Axis.X;
        Direction direction = isAxisX ? Direction.WEST : Direction.NORTH;
        int height = this.getPortcullisHeight(worldIn, pos, axis);
        int widthLeft = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? Direction.EAST : Direction.SOUTH);
        int widthRight = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? Direction.WEST : Direction.NORTH);
        if (height > 16 || widthLeft + widthRight + 1 > 16) {
            return;
        }
        if (openState) {
            int vertical;
            int horizontal;
            for (horizontal = 1; horizontal <= widthLeft; ++horizontal) {
                for (vertical = 0; vertical < height; ++vertical) {
                    state = worldIn.getBlockState(pos.relative(isAxisX ? Direction.EAST : Direction.SOUTH, horizontal).below(vertical));
                    if (state.getBlock() instanceof PortcullisBlock) {
                        if (state.getValue(HORIZONTAL_AXIS) == axis) continue;
                        openState = false;
                        break;
                    }
                    openState = false;
                    break;
                }
                if (!openState) break;
            }
            if (openState) {
                for (horizontal = 1; horizontal <= widthRight; ++horizontal) {
                    for (vertical = 0; vertical < height; ++vertical) {
                        state = worldIn.getBlockState(pos.relative(direction, horizontal).below(vertical));
                        if (state.getBlock() instanceof PortcullisBlock) {
                            if (state.getValue(HORIZONTAL_AXIS) == axis) continue;
                            openState = false;
                            break;
                        }
                        openState = false;
                        break;
                    }
                    if (!openState) break;
                }
            }
            if (openState) {
                openState = this.isCorrectBorder(worldIn, pos.relative(direction, -widthLeft).above(), axis, isAxisX ? Direction.WEST : Direction.NORTH, widthLeft + widthRight);
                openState = openState && this.isCorrectBorder(worldIn, pos.relative(direction, -widthLeft).below(height), axis, isAxisX ? Direction.WEST : Direction.NORTH, widthLeft + widthRight);
                openState = openState && this.isCorrectBorder(worldIn, pos.relative(direction, -widthLeft - 1), axis, Direction.DOWN, height - 1);
                openState = openState && this.isCorrectBorder(worldIn, pos.relative(direction, widthRight + 1), axis, Direction.DOWN, height - 1);
            }
        }
        pos = pos.relative(direction, -widthLeft);
        for (int horizontal = 0; horizontal < widthLeft + widthRight + 1; ++horizontal) {
            for (int vertical = 0; vertical < height; ++vertical) {
                BlockPos newPos = pos.relative(direction, horizontal).below(vertical);
                state = worldIn.getBlockState(newPos);
                if (!(state.getBlock() instanceof PortcullisBlock) || state.getValue(HORIZONTAL_AXIS) != axis) continue;
                worldIn.setBlock(newPos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(openState)), 10);
                if (horizontal != widthLeft) continue;
                if (vertical == 0 && openState) {
                    worldIn.levelEvent(null, this.getOpenSound(), newPos, 0);
                }
                if (vertical != height - 1 || openState) continue;
                worldIn.levelEvent(null, this.getCloseSound(), newPos, 0);
            }
        }
    }

    private int getPortcullisHeight(Level worldIn, BlockPos pos, Direction.Axis axis) {
        int height = 0;
        boolean isSamePortcullis = true;
        while (isSamePortcullis) {
            BlockState state = worldIn.getBlockState(pos = pos.below());
            if (state.getBlock() instanceof PortcullisBlock) {
                if (state.getValue(HORIZONTAL_AXIS) != axis) {
                    isSamePortcullis = false;
                }
            } else {
                isSamePortcullis = false;
            }
            ++height;
        }
        return height;
    }

    private int getPortcullisWidth(Level worldIn, BlockPos pos, Direction.Axis axis, Direction direction) {
        int width = 0;
        boolean isSamePortcullis = true;
        while (isSamePortcullis) {
            BlockState state = worldIn.getBlockState(pos = pos.relative(direction));
            if (state.getBlock() instanceof PortcullisBlock) {
                if (state.getValue(HORIZONTAL_AXIS) != axis) {
                    isSamePortcullis = false;
                }
            } else {
                isSamePortcullis = false;
            }
            ++width;
        }
        return width - 1;
    }

    private boolean isCorrectBorder(Level worldIn, BlockPos pos, Direction.Axis axis, Direction direction, int length) {
        for (int i = 0; i <= length; ++i) {
            BlockState state = worldIn.getBlockState(pos.relative(direction, i));
            if (!(state.getBlock() instanceof PortcullisBlock) || state.getValue(HORIZONTAL_AXIS) != axis) continue;
            return false;
        }
        return true;
    }

    private int getCloseSound() {
        return 1011;
    }

    private int getOpenSound() {
        return 1005;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
            return (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return super.rotate(state, rot);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Utils.addTooltip(tooltip, this, new String[0]);
    }
}

