/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class PlanterBlock
extends BlockAA {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;

    public PlanterBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.PLANTER_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.BOTTOM));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, HALF});
    }

    @Override
    public int getShapeIndex(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 2 * ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        return state.getValue(HALF) == Half.BOTTOM ? index : index + 1;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        Direction direction = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        if (state != null) {
            return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.getClickLocation().y - (double)pos.getY() > 0.5) ? Half.BOTTOM : Half.TOP));
        }
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return this.rotate(state, Rotation.CLOCKWISE_180);
    }
}

