/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.BeamBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class PergolaBlock
extends BeamBlock {
    public PergolaBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
    }

    public PergolaBlock(BlockBehaviour.Properties properties) {
        this(properties, VoxelShapes.PERGOLA_SHAPES);
    }

    @Override
    @Nonnull
    public BlockStatePropertiesAA.PillarConnection getBlockPillarConnectionAbove(BlockState state) {
        return (Boolean)state.getValue((Property)AXIS_Y) != false ? BlockStatePropertiesAA.PillarConnection.SIX_PX : BlockStatePropertiesAA.PillarConnection.NOTHING;
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBeamBottom(stateIn, facingState) && (Boolean)stateIn.getValue((Property)AXIS_Y) != false && !((BlockStatePropertiesAA.ClimbingPlant)((Object)stateIn.getValue((Property)CLIMBING_PLANT))).hasNoPlant() && !this.canSustainClimbingPlant(facingState) && Block.canSupportCenter((LevelReader)worldIn, (BlockPos)facingPos, (Direction)Direction.UP)));
        }
        return stateIn;
    }

    @Override
    public void placePlant(BlockState state, Level world, BlockPos pos, int option) {
        BlockPos posUnder = pos.below();
        BlockState stateUnder = world.getBlockState(posUnder);
        super.placePlant((BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBeamBottom(state, stateUnder) && (Boolean)state.getValue((Property)AXIS_Y) != false && !((BlockStatePropertiesAA.ClimbingPlant)((Object)state.getValue((Property)CLIMBING_PLANT))).hasNoPlant() && !this.canSustainClimbingPlant(stateUnder) && Block.canSupportCenter((LevelReader)world, (BlockPos)posUnder, (Direction)Direction.UP))), world, pos, option);
    }

    @Override
    public boolean canHavePlant(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.getBlock() != this) {
            state = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        }
        return switch (context.getClickedFace().getAxis()) {
            case Direction.Axis.X -> (BlockState)state.setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(true));
            default -> (BlockState)state.setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(true));
            case Direction.Axis.Z -> (BlockState)state.setValue((Property)AXIS_Z, (Comparable)Boolean.valueOf(true));
        };
    }
}

