/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftimebuilder.block.IBlockClimbingPlant;
import org.dawnoftimebuilder.block.templates.WaterloggedBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.Utils;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class LatticeBlock
extends WaterloggedBlock
implements IBlockClimbingPlant {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final EnumProperty<BlockStatePropertiesAA.ClimbingPlant> CLIMBING_PLANT = BlockStatePropertiesAA.CLIMBING_PLANT;
    private static final IntegerProperty AGE = BlockStatePropertiesAA.AGE_0_6;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;

    public LatticeBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.LATTICE_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(CLIMBING_PLANT, (Comparable)((Object)BlockStatePropertiesAA.ClimbingPlant.NONE))).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, CLIMBING_PLANT, AGE, PERSISTENT});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            index += 8;
        }
        if (index > 14) {
            index = 0;
        }
        return index;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.getBlock() != this) {
            state = super.getStateForPlacement(context);
        }
        return switch (context.getHorizontalDirection()) {
            default -> (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true));
            case Direction.WEST -> (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(true));
            case Direction.NORTH -> (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(true));
            case Direction.EAST -> (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(true));
        };
    }

    public boolean canBeReplaced(@NotNull BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        if (useContext.getPlayer() != null && useContext.getPlayer().isCrouching()) {
            return false;
        }
        if (itemstack.getItem() == this.asItem()) {
            Direction newDirection = useContext.getHorizontalDirection();
            return switch (newDirection) {
                default -> {
                    if (!((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.WEST -> {
                    if (!((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.NORTH -> {
                    if (!((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.EAST -> (Boolean)state.getValue((Property)EAST) == false;
            };
        }
        return false;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return !((BlockStatePropertiesAA.ClimbingPlant)((Object)state.getValue(CLIMBING_PLANT))).hasNoPlant();
    }

    public void spawnAfterBreak(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack stack, boolean p_222953_) {
        super.spawnAfterBreak(state, worldIn, pos, stack, p_222953_);
        this.dropPlant(state, (LevelAccessor)worldIn, pos, stack, p_222953_);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        this.tickPlant(state, (Level)worldIn, pos, random);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && Utils.useLighter(worldIn, pos, player, player.getUsedItemHand())) {
            Random rand = new Random();
            for (int i = 0; i < 5; ++i) {
                worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + rand.nextDouble(), (double)pos.getY() + 0.5 + rand.nextDouble() / 2.0, (double)pos.getZ() + rand.nextDouble(), 0.0, 0.07, 0.0);
            }
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 10);
            return InteractionResult.SUCCESS;
        }
        if (player.isCreative() ? this.tryPlacingPlant(state, worldIn, pos, player, player.getUsedItemHand()) : worldIn.getBlockState(pos.below()).is(BlockTags.DIRT) && this.tryPlacingPlant(state, worldIn, pos, player, player.getUsedItemHand())) {
            return InteractionResult.SUCCESS;
        }
        return this.harvestPlant(state, worldIn, pos, player, player.getUsedItemHand());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Utils.addTooltip(tooltip, "climbing_plant");
    }
}

