/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.SoilCropsBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.Utils;

public class GrowingBushBlock
extends SoilCropsBlock {
    public final VoxelShape[] SHAPES;
    public final int cutAge;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;
    private static final BooleanProperty CUT = BlockStatePropertiesAA.CUT;

    public GrowingBushBlock(SoilCropsBlock.PlantType plantType, int cutAge) {
        super(plantType);
        this.cutAge = cutAge;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)CUT, (Comparable)Boolean.valueOf(false))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.makeShapes();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, PERSISTENT, CUT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int index = (Integer)state.getValue((Property)AGE);
        return (Boolean)state.getValue((Property)CUT) != false ? this.SHAPES[5] : this.SHAPES[index];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)AGE) == 0 ? Shapes.empty() : super.getShape(state, worldIn, pos, context);
    }

    public VoxelShape[] makeShapes() {
        return new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.5, (double)11.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.5, (double)13.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), Block.box((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)12.0, (double)14.5), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0)};
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public BooleanProperty getCutProperty() {
        return CUT;
    }

    public int getMaxAge() {
        return 5;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player playerIn, BlockHitResult ray) {
        if (super.useWithoutItem(state, worldIn, pos, playerIn, ray) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (this.isMaxAge(state) && !playerIn.isCreative() && !worldIn.isClientSide()) {
            ItemStack itemStackHand = playerIn.getItemInHand(playerIn.getUsedItemHand());
            boolean holdShears = itemStackHand.is(Items.SHEARS);
            if (holdShears) {
                itemStackHand.hurtAndBreak(1, (LivingEntity)playerIn, playerIn.getEquipmentSlotForItem(itemStackHand));
            }
            ResourceLocation resourceLocation = this.builtInRegistryHolder().key().location();
            this.harvestWithoutBreaking(state, worldIn, pos, itemStackHand, resourceLocation.getPath(), holdShears ? 1.5f : 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void harvestWithoutBreaking(BlockState state, Level worldIn, BlockPos pos, ItemStack itemStackHand, String blockName, float dropMultiplier) {
        List<ItemStack> drops = Utils.getLootList((ServerLevel)worldIn, state, itemStackHand, blockName);
        Utils.dropLootFromList((LevelAccessor)worldIn, pos, drops, dropMultiplier);
        worldIn.playSound(null, pos, SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        worldIn.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(this.cutAge))).setValue((Property)CUT, (Comparable)Boolean.valueOf(true)), 2);
    }
}

