/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftimebuilder.block.IBlockSpecialDisplay;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.util.VoxelShapes;

public class FlowerPotBlockAA
extends BlockAA
implements IBlockSpecialDisplay {
    private Item itemInPot;

    public FlowerPotBlockAA(@Nullable Item itemInPot) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT), VoxelShapes.FLOWER_POT_SHAPE);
        this.itemInPot = itemInPot;
    }

    public void setItemInPot(@Nullable Item itemInPot) {
        this.itemInPot = itemInPot;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player entity, BlockHitResult ray) {
        if (this.itemInPot != null && !world.isClientSide() && entity.getItemInHand(entity.getUsedItemHand()).isEmpty()) {
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)this.itemInPot));
            world.setBlock(pos, Blocks.FLOWER_POT.defaultBlockState(), 2);
        }
        return super.useWithoutItem(state, world, pos, entity, ray);
    }

    public BlockState getRandomState() {
        return this.defaultBlockState();
    }

    @Override
    public float getDisplayScale() {
        return 0.667f;
    }
}

