/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftimebuilder.block.general.WaterSourceTrickleBlock;
import org.dawnoftimebuilder.block.general.WaterTrickleBlock;
import org.dawnoftimebuilder.block.templates.PoolBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.jetbrains.annotations.NotNull;

public class FaucetBlock
extends WaterSourceTrickleBlock {
    public FaucetBlock(BlockBehaviour.Properties propertiesIn) {
        super(propertiesIn);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStatePropertiesAA.ACTIVATED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext contextIn) {
        Level level = contextIn.getLevel();
        BlockPos pos = contextIn.getClickedPos();
        BlockState currentState = level.getBlockState(pos);
        Direction targetDirection = contextIn.getHorizontalDirection();
        BlockState outState = currentState.is((Block)this) ? currentState : this.defaultBlockState();
        return (BlockState)outState.setValue((Property)FaucetBlock.getPropertyFromDirection(targetDirection), (Comparable)Boolean.valueOf(true));
    }

    @Override
    public boolean[] getWaterTrickleOutPut(BlockState currentState) {
        if (!((Boolean)currentState.getValue((Property)BlockStatePropertiesAA.ACTIVATED)).booleanValue()) {
            return new boolean[]{(Boolean)currentState.getValue((Property)BlockStatePropertiesAA.NORTH_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.EAST_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.SOUTH_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.WEST_TRICKLE), (Boolean)currentState.getValue((Property)BlockStatePropertiesAA.CENTER_TRICKLE)};
        }
        return super.getWaterTrickleOutPut(currentState);
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState blockStateIn, Level worldIn, BlockPos blockPosIn, Player playerEntityIn, BlockHitResult blockRaytraceResultIn) {
        ItemStack mainHandItemStack = playerEntityIn.getMainHandItem();
        if (!mainHandItemStack.isEmpty() && mainHandItemStack.getItem() == this.asItem()) {
            return InteractionResult.PASS;
        }
        boolean activated = (Boolean)blockStateIn.getValue((Property)BlockStatePropertiesAA.ACTIVATED) == false;
        blockStateIn = (BlockState)blockStateIn.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(activated));
        if (activated) {
            blockStateIn = (BlockState)blockStateIn.setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(true));
        }
        if (!worldIn.isClientSide()) {
            worldIn.scheduleTick(blockPosIn, (Block)this, 5);
        }
        worldIn.setBlock(blockPosIn, blockStateIn, 10);
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction directionIn, BlockState facingStateIn, LevelAccessor worldIn, BlockPos currentPosIn, BlockPos facingPosIn) {
        BlockState state = super.updateShape(stateIn, directionIn, facingStateIn, worldIn, currentPosIn, facingPosIn);
        boolean lastActivation = (Boolean)state.getValue((Property)BlockStatePropertiesAA.ACTIVATED);
        switch (directionIn) {
            case NORTH: {
                if (!((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue() || !(facingStateIn.getBlock() instanceof PoolBlock)) break;
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= ((PoolBlock)facingStateIn.getBlock()).faucetLevel));
                break;
            }
            case SOUTH: {
                if (!((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue() || !(facingStateIn.getBlock() instanceof PoolBlock)) break;
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= ((PoolBlock)facingStateIn.getBlock()).faucetLevel));
                break;
            }
            case EAST: {
                if (!((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue() || !(facingStateIn.getBlock() instanceof PoolBlock)) break;
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= ((PoolBlock)facingStateIn.getBlock()).faucetLevel));
                break;
            }
            case WEST: {
                if (!((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue() || !(facingStateIn.getBlock() instanceof PoolBlock)) break;
                int level = (Integer)facingStateIn.getValue((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.setValue((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= ((PoolBlock)facingStateIn.getBlock()).faucetLevel));
                break;
            }
            case DOWN: {
                if (!((Boolean)state.getValue((Property)BlockStatePropertiesAA.ACTIVATED)).booleanValue()) break;
                state = facingStateIn.getBlock() instanceof WaterTrickleBlock ? (BlockState)state.setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(false)) : (BlockState)state.setValue((Property)BlockStateProperties.UNSTABLE, (Comparable)Boolean.valueOf(true));
            }
        }
        if (!worldIn.isClientSide() && (Boolean)state.getValue((Property)BlockStatePropertiesAA.ACTIVATED) != lastActivation) {
            worldIn.scheduleTick(currentPosIn, (Block)this, 5);
        }
        return state;
    }
}

