/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.WaterloggedBlock;
import org.dawnoftimebuilder.blockentity.DryerBlockEntity;
import org.dawnoftimebuilder.registry.DoTBBlockEntitiesRegistry;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.jetbrains.annotations.NotNull;

public class DryerBlock
extends WaterloggedBlock
implements EntityBlock {
    public static final IntegerProperty SIZE = BlockStatePropertiesAA.SIZE_0_2;

    public DryerBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)SIZE, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, @NotNull BlockEntityType<T> entityType) {
        return !pLevel.isClientSide() ? (pLevel1, pPos, pState1, entity) -> ((DryerBlockEntity)entity).tick() : null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SIZE});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Integer)state.getValue((Property)SIZE);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(pos);
        if (state.getBlock() == this) {
            return (BlockState)state.setValue((Property)SIZE, (Comparable)Integer.valueOf(context.getLevel().getBlockState(pos.above()).getBlock() == this ? 2 : 1));
        }
        return super.getStateForPlacement(context);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        if ((Integer)state.getValue((Property)SIZE) == 0 && itemstack.getItem() == this.asItem()) {
            return useContext.replacingClickedOnBlock();
        }
        return false;
    }

    public void onRemove(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.getBlock() != newState.getBlock() && (tileEntity = worldIn.getBlockEntity(pos)) instanceof DryerBlockEntity) {
            DryerBlockEntity dryerBlockEntity = (DryerBlockEntity)tileEntity;
            dryerBlockEntity.itemHandler.removeAllItems().forEach(h -> {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)h);
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)h);
            });
        }
        super.onRemove(oldState, worldIn, pos, newState, isMoving);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState stateDown = worldIn.getBlockState(pos = pos.below());
        if (stateDown.getBlock() == this) {
            return (Integer)stateDown.getValue((Property)SIZE) != 0;
        }
        return Block.canSupportRigidBlock((BlockGetter)worldIn, (BlockPos)pos);
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing == Direction.DOWN && !this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (facing == Direction.UP) {
            return (BlockState)stateIn.setValue((Property)SIZE, (Comparable)Integer.valueOf((Integer)stateIn.getValue((Property)SIZE) != 0 && facingState.getBlock() == this ? 2 : 1));
        }
        return stateIn;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return DoTBBlockEntitiesRegistry.INSTANCE.DRYER.get().create(pPos, pState);
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!worldIn.isClientSide() && player.getUsedItemHand() == InteractionHand.MAIN_HAND && (blockEntity = worldIn.getBlockEntity(pos)) instanceof DryerBlockEntity) {
            DryerBlockEntity dryerEntity = (DryerBlockEntity)blockEntity;
            if (player.isCrouching()) {
                return dryerEntity.dropOneItem(worldIn, pos);
            }
            ItemStack handStack = player.getItemInHand(player.getUsedItemHand());
            return dryerEntity.tryInsertItemStack(handStack, (Integer)state.getValue((Property)SIZE) == 0, worldIn, pos, player);
        }
        return InteractionResult.FAIL;
    }
}

