/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.GrowingBushBlock;
import org.dawnoftimebuilder.block.templates.SoilCropsBlock;
import org.dawnoftimebuilder.platform.Services;

public class DoubleGrowingBushBlock
extends GrowingBushBlock {
    public final int growingAge;
    public final VoxelShape[] TOP_SHAPES;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;

    public DoubleGrowingBushBlock(SoilCropsBlock.PlantType plantType, int cutAge, int growingAge) {
        super(plantType, cutAge);
        this.growingAge = growingAge;
        this.TOP_SHAPES = this.makeTopShapes();
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == Half.BOTTOM) {
            return this.SHAPES[Math.min(this.getAge(state), this.SHAPES.length - 1)];
        }
        return this.TOP_SHAPES[Math.min((Boolean)state.getValue((Property)this.getCutProperty()) != false ? this.getMaxAge() : this.getAge(state), this.TOP_SHAPES.length - 1)];
    }

    @Override
    public VoxelShape[] makeShapes() {
        return new VoxelShape[]{Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)6.0, (double)10.5), Block.box((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)16.0, (double)11.5), Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), (VoxelShape)Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)};
    }

    public VoxelShape[] makeTopShapes() {
        return new VoxelShape[]{Shapes.empty(), Shapes.empty(), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)};
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Half half = (Half)stateIn.getValue(HALF);
        if (facing.getAxis() == Direction.Axis.Y && half == Half.BOTTOM == (facing == Direction.UP)) {
            if (facingState.getBlock() == this && facingState.getValue(HALF) != half) {
                stateIn = (BlockState)stateIn.setValue((Property)PERSISTENT, (Comparable)((Boolean)facingState.getValue((Property)PERSISTENT)));
                return half == Half.BOTTOM ? stateIn : (BlockState)stateIn.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getAge(facingState)));
            }
            if (half == Half.BOTTOM && this.getAge(stateIn) < this.growingAge) {
                return stateIn;
            }
            return Blocks.AIR.defaultBlockState();
        }
        return half == Half.BOTTOM && facing == Direction.DOWN && this.canSurvive(stateIn, (LevelReader)worldIn, currentPos.below()) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, Blocks.AIR.defaultBlockState(), te, stack);
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        Half half = (Half)state.getValue(HALF);
        BlockPos otherPos = half == Half.BOTTOM ? pos.above() : pos.below();
        BlockState blockstate = worldIn.getBlockState(otherPos);
        if (blockstate.getBlock() == this) {
            worldIn.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 35);
            worldIn.levelEvent(player, 2001, otherPos, Block.getId((BlockState)blockstate));
            ItemStack itemstack = player.getMainHandItem();
            if (!worldIn.isClientSide() && !player.isCreative()) {
                Block.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)itemstack);
                Block.dropResources((BlockState)blockstate, (Level)worldIn, (BlockPos)otherPos, null, (Entity)player, (ItemStack)itemstack);
            }
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    @Override
    public void harvestWithoutBreaking(BlockState state, Level worldIn, BlockPos pos, ItemStack itemStackHand, String blockName, float dropMultiplier) {
        boolean isTop = state.getValue(HALF) == Half.TOP;
        worldIn.setBlock(isTop ? pos.below() : pos.above(), (BlockState)((BlockState)((BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.cutAge))).setValue((Property)this.getCutProperty(), (Comparable)Boolean.valueOf(true))).setValue(HALF, (Comparable)(isTop ? Half.BOTTOM : Half.TOP)), 2);
        super.harvestWithoutBreaking(state, worldIn, pos, itemStackHand, blockName, dropMultiplier);
    }

    public void growCrops(Level worldIn, BlockPos pos, BlockState state) {
        if (this.isBottomCrop(state)) {
            BlockPos topPos;
            int newAge = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
            if (newAge > this.getMaxAge()) {
                newAge = this.getMaxAge();
            }
            if (newAge >= this.getAgeReachingTopBlock() && (worldIn.getBlockState(topPos = pos.above()).getBlock() == this || worldIn.isEmptyBlock(topPos))) {
                state = this.getStateForAge(newAge);
                worldIn.setBlock(pos, state, 2);
                worldIn.setBlock(topPos, this.getTopState(state), 2);
            }
        }
    }

    @Override
    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (this.isBottomCrop(state)) {
            int i;
            if (!worldIn.isLoaded(pos) || ((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
                return;
            }
            if (worldIn.getRawBrightness(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge()) {
                float f = Services.PLATFORM.getGrowthSpeed((Block)this, (BlockGetter)worldIn, pos);
                BlockPos topPos = pos.above();
                if ((worldIn.getBlockState(topPos).getBlock() == this || worldIn.isEmptyBlock(topPos)) && random.nextInt((int)(25.0f / f) + 1) == 0) {
                    state = this.getStateForAge(i + 1);
                    worldIn.setBlock(pos, state, 2);
                    if (i + 1 >= this.growingAge) {
                        worldIn.setBlock(topPos, this.getTopState(state), 2);
                    }
                }
            }
        }
    }

    public boolean isBottomCrop(BlockState state) {
        if (state.getBlock() instanceof DoubleGrowingBushBlock) {
            return state.getValue(HALF) == Half.BOTTOM;
        }
        return false;
    }

    public BlockState getTopState(BlockState bottomState) {
        return (BlockState)bottomState.setValue(HALF, (Comparable)Half.TOP);
    }

    public int getAgeReachingTopBlock() {
        return this.growingAge;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState stateUnder;
        if (state.getValue(HALF) == Half.TOP && (stateUnder = worldIn.getBlockState(pos.below())).getBlock() == this) {
            return stateUnder.getValue(HALF) == Half.BOTTOM;
        }
        return super.canSurvive(state, worldIn, pos);
    }

    @Override
    public void setPlantWithAge(BlockState currentState, LevelAccessor worldIn, BlockPos pos, int newAge) {
        BlockPos posUp;
        if (currentState.getValue(HALF) == Half.TOP) {
            pos = pos.below();
        }
        if (newAge >= this.getAgeReachingTopBlock() && (worldIn.getBlockState(posUp = pos.above()).getBlock() == this || worldIn.isEmptyBlock(posUp))) {
            worldIn.setBlock(posUp, (BlockState)((BlockState)currentState.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(newAge))).setValue(HALF, (Comparable)Half.TOP), 10);
        }
        if (newAge < this.getAgeReachingTopBlock() && this.getAge(currentState) == this.getAgeReachingTopBlock()) {
            worldIn.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 10);
        }
        worldIn.setBlock(pos, (BlockState)((BlockState)currentState.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(newAge))).setValue(HALF, (Comparable)Half.BOTTOM), 10);
    }
}

