/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.SoilCropsBlock;
import org.dawnoftimebuilder.platform.Services;
import org.jetbrains.annotations.NotNull;

public class DoubleCropsBlock
extends SoilCropsBlock {
    private final int growingAge;
    public final VoxelShape[] SHAPES;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;

    public DoubleCropsBlock(SoilCropsBlock.PlantType plantType, int growingAge) {
        super(plantType);
        this.growingAge = growingAge;
        this.SHAPES = this.makeShapes();
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.BOTTOM)).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int index = (Integer)state.getValue((Property)AGE);
        if (index >= this.getAgeReachingTopBlock()) {
            index = state.getValue(HALF) == Half.BOTTOM ? this.getAgeReachingTopBlock() : index + 1;
        }
        return this.SHAPES[index];
    }

    public VoxelShape[] makeShapes() {
        return new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.isBottomCrop(stateIn)) {
            if (facing == Direction.UP) {
                if (facingState.getBlock() == this && !this.isBottomCrop(facingState)) {
                    return (BlockState)stateIn.setValue((Property)PERSISTENT, (Comparable)((Boolean)facingState.getValue((Property)PERSISTENT)));
                }
                return (Integer)stateIn.getValue((Property)AGE) < this.getAgeReachingTopBlock() ? stateIn : this.getRemovedState(stateIn);
            }
        } else if (facing == Direction.DOWN) {
            if (facingState.getBlock() == this && this.isBottomCrop(facingState)) {
                return (BlockState)((BlockState)stateIn.setValue((Property)AGE, (Comparable)((Integer)facingState.getValue((Property)AGE)))).setValue((Property)PERSISTENT, (Comparable)((Boolean)facingState.getValue((Property)PERSISTENT)));
            }
            return this.getRemovedState(stateIn);
        }
        return stateIn;
    }

    @Override
    public void setPlantWithAge(BlockState currentState, LevelAccessor worldIn, BlockPos pos, int newAge) {
        BlockPos posUp;
        if (currentState.getValue(HALF) == Half.TOP) {
            pos = pos.below();
        }
        if (newAge >= this.getAgeReachingTopBlock() && (worldIn.getBlockState(posUp = pos.above()).getBlock() == this || worldIn.isEmptyBlock(posUp))) {
            worldIn.setBlock(posUp, (BlockState)((BlockState)currentState.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(newAge))).setValue(HALF, (Comparable)Half.TOP), 10);
        }
        if (newAge < this.getAgeReachingTopBlock() && this.getAge(currentState) == this.getAgeReachingTopBlock()) {
            worldIn.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 10);
        }
        worldIn.setBlock(pos, (BlockState)((BlockState)currentState.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(newAge))).setValue(HALF, (Comparable)Half.BOTTOM), 10);
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, Blocks.AIR.defaultBlockState(), te, stack);
    }

    @NotNull
    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        Half half = (Half)state.getValue(HALF);
        BlockPos otherPos = half == Half.BOTTOM ? pos.above() : pos.below();
        BlockState otherState = worldIn.getBlockState(otherPos);
        if (otherState.getBlock() == this) {
            worldIn.setBlock(otherPos, this.getRemovedState(otherState), 35);
            worldIn.levelEvent(player, 2001, otherPos, Block.getId((BlockState)otherState));
            ItemStack itemstack = player.getMainHandItem();
            if (!worldIn.isClientSide() && !player.isCreative()) {
                Block.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)itemstack);
                Block.dropResources((BlockState)otherState, (Level)worldIn, (BlockPos)otherPos, null, (Entity)player, (ItemStack)itemstack);
            }
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public BlockState getRemovedState(BlockState state) {
        return Blocks.AIR.defaultBlockState();
    }

    public void growCrops(Level worldIn, BlockPos pos, BlockState state) {
        if (this.isBottomCrop(state)) {
            BlockPos topPos;
            int newAge = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
            if (newAge > this.getMaxAge()) {
                newAge = this.getMaxAge();
            }
            if (newAge >= this.getAgeReachingTopBlock() && (worldIn.getBlockState(topPos = pos.above()).getBlock() == this || worldIn.isEmptyBlock(topPos))) {
                state = this.getStateForAge(newAge);
                worldIn.setBlock(pos, state, 2);
                worldIn.setBlock(topPos, this.getTopState(state), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (this.isBottomCrop(state)) {
            int i;
            if (!worldIn.isLoaded(pos) || ((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
                return;
            }
            if (worldIn.getRawBrightness(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge()) {
                float f = Services.PLATFORM.getGrowthSpeed((Block)this, (BlockGetter)worldIn, pos);
                BlockPos topPos = pos.above();
                if ((worldIn.getBlockState(topPos).getBlock() == this || worldIn.isEmptyBlock(topPos)) && random.nextInt((int)(25.0f / f) + 1) == 0) {
                    state = this.getStateForAge(i + 1);
                    worldIn.setBlock(pos, state, 2);
                    if (i + 1 >= this.getAgeReachingTopBlock()) {
                        worldIn.setBlock(topPos, this.getTopState(state), 2);
                    }
                }
            }
        }
    }

    public boolean isBottomCrop(BlockState state) {
        if (state.getBlock() instanceof DoubleCropsBlock) {
            return state.getValue(HALF) == Half.BOTTOM;
        }
        return false;
    }

    public BlockState getTopState(BlockState bottomState) {
        return (BlockState)bottomState.setValue(HALF, (Comparable)Half.TOP);
    }

    public int getAgeReachingTopBlock() {
        return this.growingAge;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.getValue(HALF) == Half.TOP) {
            return true;
        }
        return super.canSurvive(state, worldIn, pos);
    }
}

