/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.WaterloggedBlock;
import org.dawnoftimebuilder.blockentity.DisplayerBlockEntity;
import org.dawnoftimebuilder.container.DisplayerMenu;
import org.dawnoftimebuilder.platform.Services;
import org.dawnoftimebuilder.registry.DoTBBlockEntitiesRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class DisplayerBlock
extends WaterloggedBlock
implements EntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    protected DisplayerBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return DoTBBlockEntitiesRegistry.INSTANCE.DISPLAYER.get().create(pPos, pState);
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level world, BlockPos pos, Player playerEntity, BlockHitResult rayTraceResult) {
        BlockEntity tileEntity;
        if (!world.isClientSide() && (tileEntity = world.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)tileEntity;
            Services.PLATFORM.openScreenHandler(playerEntity, provider, player -> new DisplayerMenu.DisplayerMenuData(pos));
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.getBlock() != newState.getBlock() && (tileEntity = worldIn.getBlockEntity(pos)) instanceof DisplayerBlockEntity) {
            DisplayerBlockEntity displayerEntity = (DisplayerBlockEntity)tileEntity;
            displayerEntity.itemHandler.removeAllItems().forEach(itemStack -> Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack));
        }
        super.onRemove(oldState, worldIn, pos, newState, isMoving);
    }

    public abstract double getDisplayerX(BlockState var1);

    public abstract double getDisplayerY(BlockState var1);

    public abstract double getDisplayerZ(BlockState var1);
}

