/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.ConnectedVerticalSidedBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.jetbrains.annotations.NotNull;

public class ConnectedVerticalSidedPlanBlock
extends ConnectedVerticalSidedBlock {
    public static final EnumProperty<BlockStatePropertiesAA.HorizontalConnection> HORIZONTAL_CONNECTION = BlockStatePropertiesAA.HORIZONTAL_CONNECTION;

    public ConnectedVerticalSidedPlanBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HORIZONTAL_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.HorizontalConnection.NONE)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HORIZONTAL_CONNECTION});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 16 * ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        index += 4 * ((BlockStatePropertiesAA.VerticalConnection)((Object)state.getValue((Property)VERTICAL_CONNECTION))).getIndex();
        return index += ((BlockStatePropertiesAA.HorizontalConnection)((Object)state.getValue(HORIZONTAL_CONNECTION))).getIndex();
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing.getAxis() == ((Direction)stateIn.getValue((Property)FACING)).getClockWise().getAxis() ? (BlockState)stateIn.setValue(HORIZONTAL_CONNECTION, (Comparable)((Object)this.getLineState(worldIn, currentPos, stateIn))) : stateIn;
    }

    public BlockStatePropertiesAA.HorizontalConnection getLineState(LevelAccessor worldIn, BlockPos pos, BlockState stateIn) {
        Direction direction = ((Direction)stateIn.getValue((Property)FACING)).getClockWise();
        if (this.isConnectible(stateIn, worldIn, pos.relative(direction, -1), direction)) {
            return this.isConnectible(stateIn, worldIn, pos.relative(direction), direction) ? BlockStatePropertiesAA.HorizontalConnection.BOTH : BlockStatePropertiesAA.HorizontalConnection.LEFT;
        }
        return this.isConnectible(stateIn, worldIn, pos.relative(direction), direction) ? BlockStatePropertiesAA.HorizontalConnection.RIGHT : BlockStatePropertiesAA.HorizontalConnection.NONE;
    }

    @Override
    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
    }
}

