/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.templates.DisplayerBlock;
import org.dawnoftimebuilder.registry.DoTBBlockEntitiesRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectedHorizontalPlanDoubleTableBlock
extends DisplayerBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;

    public ConnectedHorizontalPlanDoubleTableBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = (Boolean)state.getValue((Property)SOUTH) != false ? 0 : 1;
        index += (Boolean)state.getValue((Property)WEST) != false ? 0 : 2;
        index += (Boolean)state.getValue((Property)NORTH) != false ? 0 : 4;
        return state.getValue(HALF) == Half.TOP ? index + 1 : (index += (Boolean)state.getValue((Property)EAST) != false ? 0 : 8);
    }

    @Override
    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (!context.getLevel().getBlockState(context.getClickedPos().above()).canBeReplaced(context)) {
            return null;
        }
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(world.getBlockState(pos.north()).getBlock().equals(this)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(world.getBlockState(pos.east()).getBlock().equals(this)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(world.getBlockState(pos.south()).getBlock().equals(this)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(world.getBlockState(pos.west()).getBlock().equals(this)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, HALF});
    }

    @Override
    public InteractionResult useWithoutItem(BlockState blockState, Level world, BlockPos pos, Player playerEntity, BlockHitResult rayTraceResult) {
        return blockState.getValue(HALF) == Half.TOP ? super.useWithoutItem(blockState, world, pos, playerEntity, rayTraceResult) : InteractionResult.PASS;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return pState.getValue(HALF) == Half.TOP ? DoTBBlockEntitiesRegistry.INSTANCE.DISPLAYER.get().create(pPos, pState) : null;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)Half.TOP), 10);
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction halfDirection;
        if (facing.getAxis().isHorizontal()) {
            BlockState state = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
            boolean canConnect = facingState.getBlock().equals(this);
            return switch (facing) {
                default -> (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(canConnect));
                case Direction.WEST -> (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(canConnect));
                case Direction.SOUTH -> (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(canConnect));
                case Direction.EAST -> (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(canConnect));
            };
        }
        Direction direction = halfDirection = stateIn.getValue(HALF) == Half.TOP ? Direction.DOWN : Direction.UP;
        if (facing == halfDirection && facingState.getBlock() != this) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.getValue(HALF) == Half.TOP) {
            BlockState bottomState = worldIn.getBlockState(pos.below());
            if (bottomState.getBlock() == this) {
                return bottomState.getValue(HALF) == Half.BOTTOM;
            }
        } else {
            return true;
        }
        return false;
    }

    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos adjacentPos;
        BlockState adjacentState;
        if (!level.isClientSide() && player.isCreative() && state.getValue(HALF) == Half.TOP && (adjacentState = level.getBlockState(adjacentPos = pos.below())).is((Block)this) && adjacentState.getValue(HALF) == Half.BOTTOM) {
            level.setBlock(adjacentPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, adjacentPos, Block.getId((BlockState)state));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    public double getDisplayerX(BlockState state) {
        return 0.1875;
    }

    @Override
    public double getDisplayerY(BlockState state) {
        return 0.125;
    }

    @Override
    public double getDisplayerZ(BlockState state) {
        return 0.1875;
    }
}

