/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.dawnoftimebuilder.block.templates.PillarPaneBlock;
import org.jetbrains.annotations.NotNull;

public class BottomPaneBlock
extends PillarPaneBlock {
    private static final BooleanProperty BOTTOM = BlockStateProperties.BOTTOM;

    public BottomPaneBlock(BlockBehaviour.Properties propertiesIn) {
        super(propertiesIn);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BOTTOM});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext contextIn) {
        Level world = contextIn.getLevel();
        BlockPos pos = contextIn.getClickedPos();
        BlockState state = super.getStateForPlacement(contextIn);
        if (state != null) {
            state = (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(!(world.getBlockState(pos.below()).getBlock() instanceof BottomPaneBlock)));
        }
        return state;
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing == Direction.DOWN) {
            stateIn = (BlockState)stateIn.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(!(facingState.getBlock() instanceof BottomPaneBlock)));
        }
        return stateIn;
    }
}

