/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.templates;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.IBlockClimbingPlant;
import org.dawnoftimebuilder.block.IBlockPillar;
import org.dawnoftimebuilder.block.templates.WaterloggedBlock;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.Utils;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class BeamBlock
extends WaterloggedBlock
implements IBlockPillar,
IBlockClimbingPlant {
    public static final BooleanProperty BOTTOM = BlockStateProperties.BOTTOM;
    public static final BooleanProperty AXIS_X = BlockStatePropertiesAA.AXIS_X;
    public static final BooleanProperty AXIS_Y = BlockStatePropertiesAA.AXIS_Y;
    public static final BooleanProperty AXIS_Z = BlockStatePropertiesAA.AXIS_Z;
    public static final EnumProperty<BlockStatePropertiesAA.ClimbingPlant> CLIMBING_PLANT = BlockStatePropertiesAA.CLIMBING_PLANT;
    private static final IntegerProperty AGE = BlockStatePropertiesAA.AGE_0_6;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;

    public BeamBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_Z, (Comparable)Boolean.valueOf(false))).setValue(CLIMBING_PLANT, (Comparable)((Object)BlockStatePropertiesAA.ClimbingPlant.NONE))).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public BeamBlock(BlockBehaviour.Properties properties) {
        this(properties, VoxelShapes.BEAM_SHAPES);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BOTTOM, AXIS_Y, AXIS_X, AXIS_Z, CLIMBING_PLANT, AGE, PERSISTENT});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.getValue((Property)AXIS_Y)).booleanValue()) {
            int index = 3;
            if (((Boolean)state.getValue((Property)BOTTOM)).booleanValue()) {
                ++index;
            }
            if (((Boolean)state.getValue((Property)AXIS_X)).booleanValue()) {
                index += 2;
            }
            if (((Boolean)state.getValue((Property)AXIS_Z)).booleanValue()) {
                index += 4;
            }
            return index;
        }
        int index = (Boolean)state.getValue((Property)AXIS_Z) != false ? 1 : 0;
        return (Boolean)state.getValue((Property)AXIS_X) != false ? index * 2 : index;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.getBlock() != this) {
            state = super.getStateForPlacement(context);
        }
        switch (context.getClickedFace().getAxis()) {
            default: {
                BlockState stateUnder = context.getLevel().getBlockState(context.getClickedPos().below());
                state = (BlockState)state.setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(true));
                return (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBeamBottom(state, stateUnder)));
            }
            case X: {
                return (BlockState)state.setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(true));
            }
            case Z: 
        }
        return (BlockState)state.setValue((Property)AXIS_Z, (Comparable)Boolean.valueOf(true));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        if (useContext.getPlayer() != null && useContext.getPlayer().isCrouching()) {
            return false;
        }
        if (itemstack.getItem() == this.asItem() && useContext.replacingClickedOnBlock()) {
            return switch (useContext.getClickedFace().getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> {
                    if (!((Boolean)state.getValue((Property)AXIS_X)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (!((Boolean)state.getValue((Property)AXIS_Y)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> (Boolean)state.getValue((Property)AXIS_Z) == false;
            };
        }
        return false;
    }

    public void spawnAfterBreak(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack stack, boolean p_222953_) {
        super.spawnAfterBreak(state, worldIn, pos, stack, p_222953_);
        this.dropPlant(state, (LevelAccessor)worldIn, pos, stack, p_222953_);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return !((BlockStatePropertiesAA.ClimbingPlant)((Object)state.getValue(CLIMBING_PLANT))).hasNoPlant();
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        this.tickPlant(state, (Level)worldIn, pos, random);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && Utils.useLighter(worldIn, pos, player, player.getUsedItemHand())) {
            Random rand = new Random();
            for (int i = 0; i < 5; ++i) {
                worldIn.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + rand.nextDouble(), (double)pos.getY() + 0.5 + rand.nextDouble() / 2.0, (double)pos.getZ() + rand.nextDouble(), 0.0, 0.07, 0.0);
            }
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 10);
            return InteractionResult.SUCCESS;
        }
        BlockState stateUnder = worldIn.getBlockState(pos.below());
        if ((this.isBeamBottom(state, stateUnder) && this.canSustainClimbingPlant(stateUnder) || player.isCreative()) && this.tryPlacingPlant(state, worldIn, pos, player, player.getUsedItemHand())) {
            return InteractionResult.SUCCESS;
        }
        if (this.harvestPlant(state, worldIn, pos, player, player.getUsedItemHand()) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching()) {
            if (((BlockStatePropertiesAA.ClimbingPlant)((Object)state.getValue(CLIMBING_PLANT))).hasNoPlant()) {
                if (this.isBeamBottom(state, stateUnder)) {
                    this.placePlant((BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)BOTTOM) == false)), worldIn, pos, 10);
                    return InteractionResult.SUCCESS;
                }
            } else {
                this.placePlant(this.removePlant(state, (LevelAccessor)worldIn, pos, ItemStack.EMPTY), worldIn, pos, 10);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nonnull
    public BlockStatePropertiesAA.PillarConnection getBlockPillarConnectionAbove(BlockState state) {
        return (Boolean)state.getValue((Property)AXIS_Y) != false ? BlockStatePropertiesAA.PillarConnection.TEN_PX : BlockStatePropertiesAA.PillarConnection.NOTHING;
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Utils.addTooltip(tooltip, "beam", "climbing_plant");
    }

    @Override
    public boolean canHavePlant(BlockState state) {
        return IBlockClimbingPlant.super.canHavePlant(state) && (Boolean)state.getValue((Property)BOTTOM) == false;
    }

    public boolean isBeamBottom(BlockState state, BlockState stateUnder) {
        if (((Boolean)state.getValue((Property)AXIS_Y)).booleanValue()) {
            if (stateUnder.getBlock() instanceof BeamBlock) {
                return (Boolean)stateUnder.getValue((Property)AXIS_Y) == false;
            }
            return !(stateUnder.getBlock() instanceof IBlockClimbingPlant);
        }
        return true;
    }
}

