/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.roman;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.IBlockGeneration;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.util.BlockStatePropertiesAA;
import org.dawnoftimebuilder.util.Utils;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class CypressBlock
extends BlockAA
implements IBlockGeneration {
    public static final IntegerProperty SIZE = BlockStatePropertiesAA.SIZE_0_5;

    public CypressBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.CYPRESS_SHAPES);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)SIZE, (Comparable)Integer.valueOf(1)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SIZE});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Integer)state.getValue((Property)SIZE);
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader worldIn, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.below(), (Direction)Direction.UP) || worldIn.getBlockState(pos.below()).getBlock() == this;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos topPos;
        ItemStack heldItemStack = player.getItemInHand(player.getUsedItemHand());
        if (player.isCrouching()) {
            BlockPos topPos2 = this.getHighestCypressPos(worldIn, pos);
            if (topPos2 != pos) {
                if (!worldIn.isClientSide()) {
                    worldIn.setBlock(topPos2, Blocks.AIR.defaultBlockState(), 35);
                    if (!player.isCreative()) {
                        Block.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)heldItemStack);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (!heldItemStack.isEmpty() && heldItemStack.getItem() == this.asItem() && (topPos = this.getHighestCypressPos(worldIn, pos).above()).getY() <= 255) {
            if (!worldIn.isClientSide() && worldIn.getBlockState(topPos).isAir()) {
                worldIn.setBlock(topPos, this.defaultBlockState(), 11);
                if (!player.isCreative()) {
                    heldItemStack.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, worldIn, pos, player, hit);
    }

    private BlockPos getHighestCypressPos(Level worldIn, BlockPos pos) {
        int yOffset = 0;
        while (yOffset + pos.getY() <= 255 && worldIn.getBlockState(pos.above(yOffset)).getBlock() == this) {
            ++yOffset;
        }
        return pos.above(yOffset - 1);
    }

    public VoxelShape getBlockSupportShape(BlockState p_230335_1_, BlockGetter p_230335_2_, BlockPos p_230335_3_) {
        return Shapes.empty();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        int size;
        BlockState adjacentState = context.getLevel().getBlockState(context.getClickedPos().above());
        int n = size = adjacentState.getBlock() == this ? Math.min((Integer)adjacentState.getValue((Property)SIZE) + 1, 5) : 1;
        if (size < 3) {
            return (BlockState)this.defaultBlockState().setValue((Property)SIZE, (Comparable)Integer.valueOf(size));
        }
        adjacentState = context.getLevel().getBlockState(context.getClickedPos().below());
        return (BlockState)this.defaultBlockState().setValue((Property)SIZE, (Comparable)Integer.valueOf(adjacentState.getBlock() == this ? size : 0));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        int size;
        if (!facing.getAxis().isVertical()) {
            return stateIn;
        }
        if (!this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState adjacentState = worldIn.getBlockState(currentPos.above());
        int n = size = adjacentState.getBlock() == this ? Math.min((Integer)adjacentState.getValue((Property)SIZE) + 1, 5) : 1;
        if (size < 3) {
            return (BlockState)this.defaultBlockState().setValue((Property)SIZE, (Comparable)Integer.valueOf(size));
        }
        adjacentState = worldIn.getBlockState(currentPos.below());
        return (BlockState)this.defaultBlockState().setValue((Property)SIZE, (Comparable)Integer.valueOf(adjacentState.getBlock() == this ? size : 0));
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockPos posDown;
        BlockState stateDown;
        if (!(!worldIn.isRainingAt(pos.above()) || rand.nextInt(15) != 1 || (stateDown = worldIn.getBlockState(posDown = pos.below())).canOcclude() && stateDown.isFaceSturdy((BlockGetter)worldIn, posDown, Direction.UP))) {
            double x = (float)pos.getX() + rand.nextFloat();
            double y = (double)pos.getY() - 0.05;
            double z = (float)pos.getZ() + rand.nextFloat();
            worldIn.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource source) {
        if ((Integer)state.getValue((Property)SIZE) == 1) {
            BlockPos abovePos = pos.above();
            if (level.getBlockState(pos.below(5)).getBlock() != this && level.isEmptyBlock(abovePos) && source.nextInt(16) == 0) {
                level.setBlock(abovePos, this.defaultBlockState(), 2);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Utils.addTooltip(tooltip, "column");
    }

    @Override
    public boolean generateOnPos(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random) {
        BlockState groundState = world.getBlockState(pos.below());
        if (!groundState.is(BlockTags.DIRT)) {
            return false;
        }
        int maxSize = 2 + random.nextInt(5);
        for (int i = 0; i < maxSize; ++i) {
            if (world.getBlockState(pos.above(i)).isAir()) continue;
            return false;
        }
        world.setBlock(pos, (BlockState)state.setValue((Property)SIZE, (Comparable)Integer.valueOf(0)), 2);
        int size = 1;
        for (int i = maxSize; i > 0; --i) {
            world.setBlock(pos.above(i), (BlockState)state.setValue((Property)SIZE, (Comparable)Integer.valueOf(size)), 2);
            if (size >= 5) continue;
            ++size;
        }
        return true;
    }
}

