/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.precolumbian;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.IBlockGeneration;
import org.dawnoftimebuilder.block.templates.WildPlantBlock;
import org.jetbrains.annotations.NotNull;

public class WildMaizeBlock
extends WildPlantBlock
implements IBlockGeneration {
    private static final VoxelShape VS = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;

    public WildMaizeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Vec3 vec3d = state.getOffset(worldIn, pos);
        return VS.move(vec3d.x, vec3d.y, vec3d.z);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF});
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.getValue(HALF) == Half.TOP) {
            return true;
        }
        return super.canSurvive(state, worldIn, pos);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (!context.getLevel().getBlockState(context.getClickedPos().above()).canBeReplaced(context)) {
            return null;
        }
        return super.getStateForPlacement(context);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)Half.TOP), 10);
    }

    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos adjacentPos;
        BlockState adjacentState;
        if (!level.isClientSide() && player.isCreative() && state.getValue(HALF) == Half.TOP && (adjacentState = level.getBlockState(adjacentPos = pos.below())).is((Block)this) && adjacentState.getValue(HALF) == Half.BOTTOM) {
            level.setBlock(adjacentPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, adjacentPos, Block.getId((BlockState)state));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.getAxis().isHorizontal()) {
            return stateIn;
        }
        if (facing == Direction.UP && stateIn.getValue(HALF) == Half.BOTTOM) {
            if (facingState.getBlock() == this && facingState.getValue(HALF) == Half.TOP) {
                return stateIn;
            }
            return Blocks.AIR.defaultBlockState();
        }
        if (facing == Direction.DOWN) {
            if (stateIn.getValue(HALF) == Half.TOP ? facingState.getBlock() == this && facingState.getValue(HALF) == Half.BOTTOM : this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
                return stateIn;
            }
            return Blocks.AIR.defaultBlockState();
        }
        return stateIn;
    }

    @Override
    public boolean generateOnPos(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random) {
        if (!world.getBlockState(pos.above()).isAir()) {
            return false;
        }
        world.setBlock(pos, state, 2);
        world.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)Half.TOP), 2);
        return true;
    }
}

