/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.japanese;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.japanese.TatamiMatBlock;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.registry.DoTBBlocksRegistry;
import org.dawnoftimebuilder.util.VoxelShapes;

public class TatamiFloorBlock
extends BlockAA {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;

    public TatamiFloorBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY), VoxelShapes.TATAMI_FLOOR_SHAPES);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FACING});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState stateAbove;
        Direction directionOtherHalf;
        Direction direction = directionOtherHalf = stateIn.getValue(HALF) == Half.TOP ? (Direction)stateIn.getValue((Property)FACING) : ((Direction)stateIn.getValue((Property)FACING)).getOpposite();
        if (facing == Direction.UP && worldIn instanceof Level && TatamiFloorBlock.isFaceFull((VoxelShape)(stateAbove = worldIn.getBlockState(facingPos)).getShape((BlockGetter)worldIn, facingPos), (Direction)Direction.DOWN) && stateAbove.canOcclude()) {
            Containers.dropItemStack((Level)((Level)worldIn), (double)currentPos.getX(), (double)currentPos.getY(), (double)currentPos.getZ(), (ItemStack)new ItemStack((ItemLike)DoTBBlocksRegistry.INSTANCE.TATAMI_MAT.get().asItem()));
            new ItemStack((ItemLike)DoTBBlocksRegistry.INSTANCE.TATAMI_MAT.get().asItem());
            worldIn.setBlock(currentPos.relative(directionOtherHalf), Blocks.SPRUCE_PLANKS.defaultBlockState(), 10);
            return Blocks.SPRUCE_PLANKS.defaultBlockState();
        }
        if (facing == directionOtherHalf) {
            if (facingState.getBlock() != this) {
                return Blocks.AIR.defaultBlockState();
            }
            if (facingState.getValue((Property)FACING) != stateIn.getValue((Property)FACING) || facingState.getValue(HALF) == stateIn.getValue(HALF)) {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return stateIn;
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (!worldIn.isClientSide && player.isCrouching()) {
            BlockPos otherPos;
            boolean isTop = state.getValue(HALF) == Half.TOP;
            BlockPos blockPos = otherPos = isTop ? pos.relative((Direction)state.getValue((Property)FACING)) : pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            if (isTop) {
                if (!worldIn.isEmptyBlock(pos.above())) {
                    return InteractionResult.PASS;
                }
                if (!worldIn.isEmptyBlock(otherPos.above())) {
                    return InteractionResult.PASS;
                }
            }
            worldIn.setBlock(pos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 2);
            worldIn.setBlock(otherPos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 2);
            worldIn.setBlock(isTop ? pos.above() : otherPos.above(), (BlockState)((BlockState)((BlockState)DoTBBlocksRegistry.INSTANCE.TATAMI_MAT.get().defaultBlockState().setValue(TatamiMatBlock.HALF, (Comparable)Half.TOP)).setValue((Property)TatamiMatBlock.FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)TatamiMatBlock.ROLLED, (Comparable)Boolean.valueOf(true)), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(worldIn, pos, state, player);
        BlockPos otherPos = state.getValue(HALF) == Half.TOP ? pos.relative((Direction)state.getValue((Property)FACING)) : pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
        worldIn.setBlock(pos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 10);
        worldIn.setBlock(otherPos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 10);
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return this.rotate(state, Rotation.CLOCKWISE_180);
    }
}

