/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.japanese;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftimebuilder.block.IBlockChain;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.platform.Services;
import org.dawnoftimebuilder.registry.DoTBItemsRegistry;
import org.dawnoftimebuilder.util.Utils;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class StickBundleBlock
extends BlockAA
implements IBlockChain {
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    private static final IntegerProperty AGE = BlockStateProperties.AGE_3;

    public StickBundleBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY), VoxelShapes.STICK_BUNDLE_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(HALF, (Comparable)Half.TOP));
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return state.getValue(HALF) == Half.BOTTOM ? 1 : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, AGE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.getLevel();
        if (!world.getBlockState((pos = context.getClickedPos()).below()).canBeReplaced(context) || !this.canSurvive(this.defaultBlockState(), (LevelReader)world, pos)) {
            return null;
        }
        return super.getStateForPlacement(context);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.setBlock(pos.below(), (BlockState)state.setValue(HALF, (Comparable)Half.BOTTOM), 10);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.getAxis().isHorizontal()) {
            return stateIn;
        }
        if (facing == Direction.UP && stateIn.getValue(HALF) == Half.BOTTOM) {
            if (facingState.getBlock() == this && facingState.getValue(HALF) == Half.TOP) {
                return stateIn;
            }
            return Blocks.AIR.defaultBlockState();
        }
        if (facing == Direction.DOWN && stateIn.getValue(HALF) == Half.TOP) {
            if (facingState.getBlock() == this && facingState.getValue(HALF) == Half.BOTTOM) {
                return stateIn;
            }
            return Blocks.AIR.defaultBlockState();
        }
        return stateIn;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        pos = pos.above();
        BlockState stateUp = worldIn.getBlockState(pos);
        return state.getValue(HALF) == Half.BOTTOM || StickBundleBlock.canSupportCenter((LevelReader)worldIn, (BlockPos)pos, (Direction)Direction.DOWN) || IBlockChain.canBeChained(stateUp, true);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (!worldIn.isClientSide()) {
            ItemStack itemstack;
            if ((Integer)state.getValue((Property)AGE) == 0 && (itemstack = player.getItemInHand(player.getUsedItemHand())).getItem() == DoTBItemsRegistry.INSTANCE.SILK_WORMS.get() && !itemstack.isEmpty()) {
                itemstack.shrink(1);
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 10);
                if (state.getValue(HALF) == Half.TOP) {
                    worldIn.setBlock(pos.below(), (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.BOTTOM)).setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 10);
                } else {
                    worldIn.setBlock(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.TOP)).setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 10);
                }
                return InteractionResult.SUCCESS;
            }
            if ((Integer)state.getValue((Property)AGE) == 3) {
                List<ItemStack> drops = Utils.getLootList((ServerLevel)worldIn, state, player.getItemInHand(player.getUsedItemHand()), Objects.requireNonNull(this.builtInRegistryHolder().key()).location().getPath() + "_harvest");
                Utils.dropLootFromList((LevelAccessor)worldIn, pos, drops, 1.0f);
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 10);
                worldIn.playSound(null, pos, SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (state.getValue(HALF) == Half.TOP) {
                    worldIn.setBlock(pos.below(), (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.BOTTOM)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 10);
                } else {
                    worldIn.setBlock(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)Half.TOP)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 10);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected void randomTick(BlockState state, @NotNull ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int growth = (Integer)state.getValue((Property)AGE);
        if (growth > 0 && growth < 3 && random.nextInt(Services.PLATFORM.getConfig().stickBundleGrowthChance) == 0) {
            worldIn.setBlock(pos, (BlockState)worldIn.getBlockState(pos).setValue((Property)AGE, (Comparable)Integer.valueOf(growth + 1)), 10);
            worldIn.setBlock(pos.below(), (BlockState)worldIn.getBlockState(pos.below()).setValue((Property)AGE, (Comparable)Integer.valueOf(growth + 1)), 10);
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) > 0 && (Integer)state.getValue((Property)AGE) < 3 && state.getValue(HALF) == Half.TOP;
    }

    @Override
    public boolean canConnectToChainUnder(BlockState state) {
        return false;
    }

    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos adjacentPos;
        BlockState adjacentState;
        if (!level.isClientSide() && player.isCreative() && state.getValue(HALF) == Half.TOP && (adjacentState = level.getBlockState(adjacentPos = pos.below())).is((Block)this) && adjacentState.getValue(HALF) == Half.BOTTOM) {
            level.setBlock(adjacentPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, adjacentPos, Block.getId((BlockState)state));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }
}

