/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.japanese;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftimebuilder.block.templates.DisplayerBlock;
import org.dawnoftimebuilder.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class SpruceLowTableBlock
extends DisplayerBlock {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public SpruceLowTableBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.SPRUCE_LOW_TABLE_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HORIZONTAL_AXIS});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? 0 : 1;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)(context.getHorizontalDirection().getAxis() == Direction.Axis.Z ? Direction.Axis.X : Direction.Axis.Z));
    }

    @Override
    public double getDisplayerX(BlockState state) {
        return state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? 0.1875 : 0.3125;
    }

    @Override
    public double getDisplayerY(BlockState state) {
        return 0.46875;
    }

    @Override
    public double getDisplayerZ(BlockState state) {
        return state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? 0.3125 : 0.1875;
    }

    @Nonnull
    public BlockState rotate(@Nonnull BlockState state, @Nonnull Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
            return (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return super.rotate(state, rot);
    }
}

