/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.japanese;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.japanese.SmallTatamiMatBlock;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.dawnoftimebuilder.registry.DoTBBlocksRegistry;
import org.dawnoftimebuilder.util.VoxelShapes;

public class SmallTatamiFloorBlock
extends BlockAA {
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public SmallTatamiFloorBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.SMALL_TATAMI_FLOOR_SHAPES);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_AXIS});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState stateAbove;
        if (facing == Direction.UP && SmallTatamiFloorBlock.isFaceFull((VoxelShape)(stateAbove = worldIn.getBlockState(facingPos)).getShape((BlockGetter)worldIn, facingPos), (Direction)Direction.DOWN) && stateAbove.canOcclude()) {
            Containers.dropItemStack((Level)((Level)worldIn), (double)currentPos.getX(), (double)currentPos.getY(), (double)currentPos.getZ(), (ItemStack)new ItemStack((ItemLike)DoTBBlocksRegistry.INSTANCE.SMALL_TATAMI_MAT.get().asItem(), 1));
            return Blocks.SPRUCE_PLANKS.defaultBlockState();
        }
        return stateIn;
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isCrouching() && worldIn.isEmptyBlock(pos.above())) {
            worldIn.setBlock(pos.above(), (BlockState)((BlockState)DoTBBlocksRegistry.INSTANCE.SMALL_TATAMI_MAT.get().defaultBlockState().setValue((Property)SmallTatamiMatBlock.ROLLED, (Comparable)Boolean.valueOf(true))).setValue(SmallTatamiMatBlock.HORIZONTAL_AXIS, (Comparable)((Direction.Axis)state.getValue(HORIZONTAL_AXIS))), 10);
            worldIn.setBlock(pos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 10);
            worldIn.playSound(player, pos.above(), this.soundType.getPlaceSound(), SoundSource.BLOCKS, (this.soundType.getVolume() + 1.0f) / 2.0f, this.soundType.getPitch() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(HORIZONTAL_AXIS, (Comparable)(state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, state, te, stack);
        worldIn.setBlock(pos, Blocks.SPRUCE_PLANKS.defaultBlockState(), 10);
    }
}

