/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.japanese;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftimebuilder.block.japanese.MapleLeavesBlock;
import org.dawnoftimebuilder.block.templates.BlockAA;
import org.jetbrains.annotations.NotNull;

public class MapleTrunkBlock
extends BlockAA {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public MapleTrunkBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos blockPosIn, BlockState blockStateIn, Player playerEntityIn) {
        if (!worldIn.isClientSide) {
            if (playerEntityIn.isCreative()) {
                BlockPos trunkBlockPos = new BlockPos(blockPosIn.getX(), blockPosIn.getY(), blockPosIn.getZ());
                BlockState state = worldIn.getBlockState(trunkBlockPos);
                worldIn.setBlock(trunkBlockPos, Blocks.AIR.defaultBlockState(), 35);
                worldIn.levelEvent(playerEntityIn, 2001, blockPosIn, Block.getId((BlockState)state));
            }
            for (int x = -1; x <= 1; ++x) {
                for (int y = 1; y <= 2; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos baseBlock = new BlockPos(blockPosIn.getX() + x, blockPosIn.getY() + y, blockPosIn.getZ() + z);
                        BlockState state = worldIn.getBlockState(baseBlock);
                        worldIn.setBlock(baseBlock, Blocks.AIR.defaultBlockState(), 35);
                        worldIn.levelEvent(playerEntityIn, 2001, blockPosIn, Block.getId((BlockState)state));
                    }
                }
            }
        }
        return super.playerWillDestroy(worldIn, blockPosIn, blockStateIn, playerEntityIn);
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.block();
    }

    public VoxelShape getBlockSupportShape(BlockState p_230335_1_, BlockGetter p_230335_2_, BlockPos p_230335_3_) {
        return Shapes.empty();
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (Direction.DOWN.equals((Object)facing)) {
            BlockState state = worldIn.getBlockState(currentPos.below());
            if (!BlockTags.DIRT.equals((Object)state.getBlock())) {
                return Blocks.AIR.defaultBlockState();
            }
        } else if (Direction.UP.equals((Object)facing)) {
            BlockState state = worldIn.getBlockState(currentPos.above());
            if (!(state.getBlock() instanceof MapleLeavesBlock)) {
                return Blocks.AIR.defaultBlockState();
            }
            Direction currentFacing = (Direction)stateIn.getValue((Property)FACING);
            if (currentFacing == null || !currentFacing.equals((Object)state.getValue((Property)FACING))) {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return stateIn;
    }

    public boolean useShapeForLightOcclusion(BlockState p_220074_1_In) {
        return false;
    }

    public float getShadeBrightness(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState p_200123_1_, BlockGetter p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }
}

