/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.block.japanese;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftimebuilder.block.japanese.MapleLeavesBlock;
import org.dawnoftimebuilder.block.japanese.MapleTrunkBlock;
import org.dawnoftimebuilder.block.templates.BushBlockDoT;
import org.dawnoftimebuilder.registry.DoTBBlocksRegistry;
import org.dawnoftimebuilder.util.VoxelShapes;

public class MapleSaplingBlock
extends BushBlockDoT
implements BonemealableBlock {
    public static final IntegerProperty STAGE = BlockStateProperties.STAGE;

    public MapleSaplingBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.SAPLING_SHAPES);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult useWithoutItem(BlockState p_225533_1_In, Level p_225533_2_In, BlockPos p_225533_3_In, Player p_225533_4_In, BlockHitResult p_225533_6_In) {
        Item mainItem = p_225533_4_In.getMainHandItem().getItem();
        if (mainItem instanceof FlintAndSteelItem) {
            if (!p_225533_2_In.isClientSide) {
                p_225533_2_In.setBlock(p_225533_3_In, DoTBBlocksRegistry.INSTANCE.PAUSED_MAPLE_RED_SAPLING.get().defaultBlockState(), 35);
                p_225533_2_In.levelEvent(p_225533_4_In, 2001, p_225533_3_In, Block.getId((BlockState)p_225533_1_In));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.add(new Property[]{STAGE});
    }

    public boolean isRandomlyTicking(BlockState blockstateIn) {
        return true;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if (level.getMaxLocalRawBrightness(pos.above()) >= 9 && source.nextInt(7) == 0) {
            if (!level.isLoaded(pos)) {
                return;
            }
            this.advanceTree(level, pos, state);
        }
    }

    public void advanceTree(ServerLevel level, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)STAGE) == 0) {
            level.setBlock(pos, (BlockState)state.cycle((Property)STAGE), 4);
        } else {
            MapleSaplingBlock.placeFinalTreeIfPossible((LevelAccessor)level, pos);
        }
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level p_180670_1_, RandomSource p_180670_2_, BlockPos p_180670_3_, BlockState p_180670_4_) {
        return (double)p_180670_1_.random.nextFloat() < 0.45;
    }

    public void performBonemeal(ServerLevel level, RandomSource source, BlockPos pos, BlockState state) {
        this.advanceTree(level, pos, state);
    }

    public boolean useShapeForLightOcclusion(BlockState p_220074_1_In) {
        return false;
    }

    public float getShadeBrightness(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState p_200123_1_, BlockGetter p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    @Override
    public boolean generateOnPos(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random) {
        return MapleSaplingBlock.placeFinalTreeIfPossible((LevelAccessor)world, pos);
    }

    public static boolean isValidForPlacement(LevelAccessor worldIn, BlockPos bottomCenterIn) {
        BlockPos floorCenter = bottomCenterIn.below();
        BlockState state = worldIn.getBlockState(floorCenter);
        if (!state.is(BlockTags.DIRT)) {
            return false;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    state = worldIn.getBlockState(bottomCenterIn.offset(x, y + 1, z));
                    if (state.getBlock() instanceof AirBlock) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean placeFinalTreeIfPossible(LevelAccessor worldIn, BlockPos centerPosIn) {
        if (MapleSaplingBlock.isValidForPlacement(worldIn, centerPosIn)) {
            Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(worldIn.getRandom());
            worldIn.setBlock(centerPosIn, (BlockState)DoTBBlocksRegistry.INSTANCE.MAPLE_RED_TRUNK.get().defaultBlockState().setValue((Property)MapleTrunkBlock.FACING, (Comparable)direction), 10);
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos newBlockPosition = new BlockPos(centerPosIn.getX() + x, centerPosIn.getY() + y + 1, centerPosIn.getZ() + z);
                        worldIn.setBlock(newBlockPosition, (BlockState)((BlockState)((BlockState)((BlockState)DoTBBlocksRegistry.INSTANCE.MAPLE_RED_LEAVES.get().defaultBlockState().setValue((Property)MapleTrunkBlock.FACING, (Comparable)direction)).setValue((Property)MapleLeavesBlock.MULTIBLOCK_X, (Comparable)Integer.valueOf(x + 1))).setValue((Property)MapleLeavesBlock.MULTIBLOCK_Y, (Comparable)Integer.valueOf(y))).setValue((Property)MapleLeavesBlock.MULTIBLOCK_Z, (Comparable)Integer.valueOf(z + 1)), 10);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

